/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.trigger;

import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.trigger.RepositoryBasedTriggerProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerConditionProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class AnyTriggerProperties
extends RepositoryBasedTriggerProperties {
    private final AtlassianModuleProperties atlassianPlugin;
    private final Map<String, String> configuration;

    private AnyTriggerProperties() {
        this.atlassianPlugin = null;
        this.configuration = Collections.emptyMap();
    }

    public AnyTriggerProperties(@NotNull AtlassianModuleProperties atlassianPlugin, String name, String description, boolean isEnabled, Set<TriggerConditionProperties> conditions, Map<String, String> configuration, RepositoryBasedTrigger.TriggeringRepositoriesType triggeringRepositoriesType, List<VcsRepositoryIdentifierProperties> selectedTriggeringRepositories) throws PropertiesValidationException {
        super(name, description, isEnabled, conditions, triggeringRepositoriesType, selectedTriggeringRepositories);
        this.atlassianPlugin = atlassianPlugin;
        this.configuration = Collections.unmodifiableMap(new LinkedHashMap<String, String>(configuration));
        this.validate();
    }

    @Override
    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return this.atlassianPlugin;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkNotNull("atlassianPlugin", this.atlassianPlugin);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnyTriggerProperties that = (AnyTriggerProperties)o;
        return Objects.equals(this.atlassianPlugin, that.atlassianPlugin) && Objects.equals(this.configuration, that.configuration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.atlassianPlugin, this.configuration);
    }
}

