/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan.dependencies;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.DependenciesConfiguration;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Dependencies
extends EntityPropertiesBuilder<DependenciesProperties> {
    private DependenciesConfigurationProperties dependenciesConfigurationProperties = new DependenciesConfiguration().build();
    private List<PlanIdentifierProperties> childPlans = new ArrayList<PlanIdentifierProperties>();

    @NotNull
    public Dependencies configuration(@NotNull DependenciesConfiguration dependenciesConfiguration) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("configuration", dependenciesConfiguration);
        this.dependenciesConfigurationProperties = dependenciesConfiguration.build();
        return this;
    }

    @NotNull
    public Dependencies childPlans(PlanIdentifier ... childPlans) {
        ImporterUtils.checkNotNull("childPlan", childPlans);
        for (PlanIdentifier childPlan : childPlans) {
            ImporterUtils.checkNotNull("childPlan", childPlan);
            this.childPlans.add((PlanIdentifierProperties)EntityPropertiesBuilders.build(childPlan));
        }
        return this;
    }

    @Override
    protected DependenciesProperties build() {
        return new DependenciesProperties(this.dependenciesConfigurationProperties, this.childPlans);
    }
}

