/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanBranchIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class PlanBranchIdentifier
extends EntityPropertiesBuilder<PlanBranchIdentifierProperties> {
    private BambooKeyProperties key;
    private BambooOidProperties oid;

    public PlanBranchIdentifier(@NotNull PlanBranchIdentifier copy) {
        this.key = copy.key;
        this.oid = copy.oid;
    }

    public PlanBranchIdentifier(@NotNull BambooKey key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(key);
    }

    public PlanBranchIdentifier(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
    }

    public PlanBranchIdentifier oid(@NotNull String oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        return this.oid(new BambooOid(oid));
    }

    public PlanBranchIdentifier oid(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
        return this;
    }

    public PlanBranchIdentifier key(@NotNull String key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        return this.key(new BambooKey(key));
    }

    public PlanBranchIdentifier key(@NotNull BambooKey key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(key);
        return this;
    }

    @Override
    protected PlanBranchIdentifierProperties build() throws PropertiesValidationException {
        return new PlanBranchIdentifierProperties(this.key, this.oid);
    }
}

