/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.repository;

import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.RootEntityProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.viewer.VcsRepositoryViewerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.repository.VcsRepositoryValidator;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public abstract class VcsRepositoryProperties
implements RootEntityProperties {
    private final String name;
    private final String description;
    private final BambooOidProperties oid;
    private final VcsRepositoryViewerProperties repositoryViewerProperties;
    private final String parent;

    protected VcsRepositoryProperties() {
        this.parent = null;
        this.oid = null;
        this.name = null;
        this.description = null;
        this.repositoryViewerProperties = null;
    }

    public VcsRepositoryProperties(@Nullable String name, @Nullable BambooOidProperties oid, @Nullable String description, @Nullable String parent, @Nullable VcsRepositoryViewerProperties repositoryViewerProperties) throws PropertiesValidationException {
        this.name = name;
        this.oid = oid;
        this.description = description;
        this.repositoryViewerProperties = repositoryViewerProperties;
        this.parent = parent;
    }

    @NotNull
    private VcsRepositoryIdentifierProperties toIdentifierUnsafe() throws PropertiesValidationException {
        VcsRepositoryIdentifier repositoryIdentifier = new VcsRepositoryIdentifier();
        if (!StringUtils.isBlank((CharSequence)this.name)) {
            repositoryIdentifier.name(this.name);
        } else if (!StringUtils.isBlank((CharSequence)this.getParentName())) {
            repositoryIdentifier.name(this.parent);
        }
        if (this.oid != null) {
            repositoryIdentifier.oid(this.oid.getOid());
        }
        return (VcsRepositoryIdentifierProperties)EntityPropertiesBuilders.build(repositoryIdentifier);
    }

    public VcsRepositoryIdentifierProperties toIdentifier() {
        try {
            return this.toIdentifierUnsafe();
        }
        catch (PropertiesValidationException e) {
            String errors = e.getErrors().stream().map(ValidationProblem::getMessage).collect(Collectors.joining(", "));
            throw new IllegalStateException(errors);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRepositoryProperties that = (VcsRepositoryProperties)o;
        return Objects.equals(this.getAtlassianPlugin(), that.getAtlassianPlugin()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getRepositoryViewerProperties(), that.getRepositoryViewerProperties()) && Objects.equals(this.getParent(), that.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.getAtlassianPlugin(), this.getName(), this.getDescription(), this.getOid(), this.getRepositoryViewerProperties(), this.getParent());
    }

    @Nullable
    public abstract AtlassianModuleProperties getAtlassianPlugin();

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    @Nullable
    public VcsRepositoryViewerProperties getRepositoryViewerProperties() {
        return this.repositoryViewerProperties;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    @Nullable
    public String getParentName() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNoErrors(VcsRepositoryValidator.validate(this));
        this.toIdentifierUnsafe();
    }

    @Override
    @NotNull
    public String humanReadableType() {
        return "repository";
    }

    @Override
    @NotNull
    public String humanReadableId() {
        return String.format("%s %s", "repository", StringUtils.defaultString((String)this.name, (String)"<unknown>"));
    }
}

