/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan;

import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.builders.plan.branches.PlanBranchManagement;
import com.atlassian.bamboo.specs.api.builders.plan.dependencies.Dependencies;
import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGeneratorName;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGen;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.RootEntityProperties;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.label.LabelProperties;
import com.atlassian.bamboo.specs.api.model.notification.EmptyNotificationsListProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationProperties;
import com.atlassian.bamboo.specs.api.model.plan.AbstractPlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchManagementProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.dependencies.DependenciesProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryBranchProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.plan.PlanValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Builder(value=Plan.class)
@ConstructFrom(value={"project", "name", "key"})
@Immutable
public final class PlanProperties
extends AbstractPlanProperties
implements RootEntityProperties {
    private final ProjectProperties project;
    private final List<StageProperties> stages;
    @CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.plan.PlanRepositoriesEmitter")
    private final List<PlanRepositoryLinkProperties> repositories;
    private final List<VcsRepositoryBranchProperties> repositoryBranches;
    private final List<TriggerProperties> triggers;
    private final List<VariableProperties> variables;
    private final PlanBranchManagementProperties planBranchManagementProperties;
    private final DependenciesProperties dependenciesProperties;
    @SkipCodeGen
    @Nullable
    private final RepositoryStoredSpecsData repositoryStoredSpecsData;
    private List<NotificationProperties> notifications;
    @CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.plan.PlanForceStopBuildEmitter")
    private final Boolean forceStopHungBuilds;
    @CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.plan.PlanLabelsEmitter")
    private final List<LabelProperties> labels;
    private final PlanBranchConfigurationProperties planBranchConfiguration;

    private PlanProperties() {
        this.project = null;
        this.stages = Collections.emptyList();
        this.repositories = Collections.emptyList();
        this.triggers = Collections.emptyList();
        this.variables = Collections.emptyList();
        this.planBranchManagementProperties = (PlanBranchManagementProperties)EntityPropertiesBuilders.build(new PlanBranchManagement());
        this.dependenciesProperties = (DependenciesProperties)EntityPropertiesBuilders.build(new Dependencies());
        this.repositoryStoredSpecsData = null;
        this.notifications = Collections.emptyList();
        this.forceStopHungBuilds = null;
        this.repositoryBranches = Collections.emptyList();
        this.labels = Collections.emptyList();
        this.planBranchConfiguration = null;
    }

    public PlanProperties(BambooOidProperties oid, BambooKeyProperties key, String name, String description, ProjectProperties project, List<StageProperties> stages, List<PlanRepositoryLinkProperties> repositories, List<TriggerProperties> triggers, List<VariableProperties> variables, boolean enabled, Collection<PluginConfigurationProperties> pluginConfigurations, PlanBranchManagementProperties planBranchManagementProperties, DependenciesProperties dependenciesProperties, @Nullable RepositoryStoredSpecsData repositoryStoredSpecsData, @NotNull List<NotificationProperties> notifications, Boolean forceStopHungBuilds, List<VcsRepositoryBranchProperties> repositoryBranches, List<LabelProperties> labels, @Nullable PlanBranchConfigurationProperties planBranchConfiguration) throws PropertiesValidationException {
        super(oid, key, name, description, enabled, pluginConfigurations);
        this.triggers = Collections.unmodifiableList(new ArrayList<TriggerProperties>(triggers));
        this.variables = Collections.unmodifiableList(new ArrayList<VariableProperties>(variables));
        this.repositories = Collections.unmodifiableList(new ArrayList<PlanRepositoryLinkProperties>(repositories));
        this.project = project;
        this.stages = Collections.unmodifiableList(new ArrayList<StageProperties>(stages));
        this.planBranchManagementProperties = planBranchManagementProperties;
        this.dependenciesProperties = dependenciesProperties;
        this.repositoryStoredSpecsData = repositoryStoredSpecsData;
        this.notifications = Collections.unmodifiableList(new ArrayList<NotificationProperties>(notifications));
        this.forceStopHungBuilds = forceStopHungBuilds;
        this.repositoryBranches = Collections.unmodifiableList(new ArrayList<VcsRepositoryBranchProperties>(repositoryBranches));
        this.labels = Collections.unmodifiableList(new ArrayList<LabelProperties>(labels));
        this.planBranchConfiguration = planBranchConfiguration;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanProperties that = (PlanProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && this.isEnabled() == that.isEnabled() && Objects.equals(this.getPluginConfigurations(), that.getPluginConfigurations()) && Objects.equals(this.getProject(), that.getProject()) && Objects.equals(this.getStages(), that.getStages()) && Objects.equals(this.getRepositories(), that.getRepositories()) && Objects.equals(this.getTriggers(), that.getTriggers()) && Objects.equals(this.getVariables(), that.getVariables()) && Objects.equals(this.getPlanBranchManagementProperties(), that.getPlanBranchManagementProperties()) && Objects.equals(this.getDependenciesProperties(), that.getDependenciesProperties()) && Objects.equals(this.getRepositoryStoredSpecsData(), that.getRepositoryStoredSpecsData()) && Objects.equals(this.getNotifications(), that.getNotifications()) && Objects.equals(this.getForceStopHungBuilds(), that.getForceStopHungBuilds()) && Objects.equals(this.getRepositoryBranches(), that.getRepositoryBranches()) && Objects.equals(this.getLabels(), that.getLabels()) && Objects.equals(this.getPlanBranchConfiguration(), that.getPlanBranchConfiguration());
    }

    public int hashCode() {
        return Objects.hashCode(this.getKey());
    }

    @NotNull
    public ProjectProperties getProject() {
        return this.project;
    }

    @NotNull
    public List<StageProperties> getStages() {
        return this.stages;
    }

    @NotNull
    public PlanBranchManagementProperties getPlanBranchManagementProperties() {
        return this.planBranchManagementProperties;
    }

    @NotNull
    public DependenciesProperties getDependenciesProperties() {
        return this.dependenciesProperties;
    }

    @NotNull
    public List<VariableProperties> getVariables() {
        return this.variables != null ? this.variables : Collections.emptyList();
    }

    @NotNull
    public List<TriggerProperties> getTriggers() {
        return this.triggers != null ? this.triggers : Collections.emptyList();
    }

    @NotNull
    public List<PlanRepositoryLinkProperties> getRepositories() {
        return this.repositories;
    }

    @NotNull
    public List<VcsRepositoryBranchProperties> getRepositoryBranches() {
        return this.repositoryBranches;
    }

    @Nullable
    public RepositoryStoredSpecsData getRepositoryStoredSpecsData() {
        return this.repositoryStoredSpecsData;
    }

    public List<NotificationProperties> getNotifications() {
        return this.notifications;
    }

    public Boolean getForceStopHungBuilds() {
        return this.forceStopHungBuilds;
    }

    @NotNull
    public List<LabelProperties> getLabels() {
        return this.labels;
    }

    @Nullable
    public PlanBranchConfigurationProperties getPlanBranchConfiguration() {
        return this.planBranchConfiguration;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of("Plan");
        ImporterUtils.checkRequired(context.with("project"), this.project);
        ImporterUtils.checkRequired(context.with("stages"), this.stages);
        ImporterUtils.checkRequired(context.with("planBranchManagementProperties"), this.planBranchManagementProperties);
        ImporterUtils.checkRequired(context.with("dependenciesProperties"), this.dependenciesProperties);
        ImporterUtils.checkRequired(context.with("notifications"), this.notifications);
        ImporterUtils.checkRequired(context.with("labels"), this.labels);
        ImporterUtils.checkNoErrors(PlanValidator.validate(this));
        ImporterUtils.checkThat("EmptyNotificationsList must be the only element on the notifications list", this.emptyListMustBeTheOnlyElement(this.notifications, EmptyNotificationsListProperties.class));
        this.validateRepositoryBranches(context);
    }

    @Override
    @NotNull
    public String humanReadableType() {
        return "plan";
    }

    @Override
    @NotNull
    public String humanReadableId() {
        if (this.getKey() != null) {
            if (this.project != null && this.project.getKey() != null) {
                return String.format("%s %s-%s", "plan", this.project.getKey().getKey(), this.getKey().getKey());
            }
            return String.format("%s %s", "plan", this.getKey().getKey());
        }
        return String.format("%s <unknown>", "plan");
    }

    private void validateRepositoryBranches(ValidationContext context) {
        Set repositoryNames = this.repositories.stream().map(r -> {
            if (r.getRepositoryDefinition().hasParent()) {
                return r.getRepositoryDefinition().getParentName();
            }
            return r.getRepositoryDefinition().getName();
        }).collect(Collectors.toSet());
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (VcsRepositoryBranchProperties branch : this.getRepositoryBranches()) {
            if (usedNames.contains(branch.getRepositoryName())) {
                problems.add(new ValidationProblem(context, "Duplicate branch definition for repository " + branch.getRepositoryName()));
            }
            usedNames.add(branch.getRepositoryName());
            if (repositoryNames.contains(branch.getRepositoryName())) continue;
            problems.add(new ValidationProblem(context, "Branch defined for unknown repository " + branch.getRepositoryName()));
        }
        if (!problems.isEmpty()) {
            throw new PropertiesValidationException(problems);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> boolean emptyListMustBeTheOnlyElement(List<T> list, Class<?> aClass) {
        if (list.size() == 1) return true;
        if (!list.stream().noneMatch(aClass::isInstance)) return false;
        return true;
    }
}

