/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.Nullable;

@Immutable
public class AbstractPlanIdentifierProperties
implements EntityProperties {
    protected final BambooKeyProperties key;
    protected final BambooOidProperties oid;

    protected AbstractPlanIdentifierProperties() {
        this.key = null;
        this.oid = null;
    }

    public AbstractPlanIdentifierProperties(@Nullable BambooKeyProperties key, @Nullable BambooOidProperties oid) throws PropertiesValidationException {
        this.key = key;
        this.oid = oid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPlanIdentifierProperties that = (AbstractPlanIdentifierProperties)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getOid(), that.getOid());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getOid());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("oid", (Object)this.oid).append("key", (Object)this.key).build();
    }

    @Nullable
    public BambooKeyProperties getKey() {
        return this.key;
    }

    public boolean isKeyDefined() {
        return this.key != null;
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    public boolean isOidDefined() {
        return this.oid != null;
    }

    @Override
    public void validate() {
        if (this.key == null && this.oid == null) {
            throw new PropertiesValidationException("Either key or oid need to be defined when referencing plan or job");
        }
    }
}

