/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.credentials;

import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsScope;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGeneratorName;
import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CodeGeneratorName(value="com.atlassian.bamboo.specs.codegen.emitters.credentials.SharedCredentialsIdentifierEmitter")
@ConstructFrom(value={"name"})
@Immutable
public final class SharedCredentialsIdentifierProperties
implements EntityProperties {
    private final BambooOidProperties oid;
    private final String name;
    private final SharedCredentialsScope scope;

    private SharedCredentialsIdentifierProperties() {
        this.name = null;
        this.oid = null;
        this.scope = SharedCredentialsScope.GLOBAL;
    }

    public SharedCredentialsIdentifierProperties(@Nullable String name, @Nullable BambooOidProperties oid, @NotNull SharedCredentialsScope scope) throws PropertiesValidationException {
        this.name = name;
        this.oid = oid;
        this.scope = scope;
        this.validate();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isNameDefined() {
        return StringUtils.isNotBlank((CharSequence)this.name);
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    public boolean isOidDefined() {
        return this.oid != null;
    }

    @NotNull
    public SharedCredentialsScope getScope() {
        return this.scope;
    }

    public boolean isScopeDefined() {
        return this.scope != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedCredentialsIdentifierProperties that = (SharedCredentialsIdentifierProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getScope(), (Object)that.getScope());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getOid(), this.getName(), this.getScope()});
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("oid", (Object)this.oid).append("name", (Object)this.name).append("scope", (Object)this.scope).build();
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.name) && this.oid == null) {
            throw new PropertiesValidationException("Either name or oid need to be defined when referencing shared credentials");
        }
        if (this.scope == null) {
            throw new PropertiesValidationException("Shared credentials scope need to be defined");
        }
    }
}

