package com.atlassian.bamboo.specs.api.builders.trigger;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.trigger.AnyTriggerConditionProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Map;

public class AnyTriggerCondition<T extends AnyTriggerCondition<T, P>, P extends AnyTriggerConditionProperties> extends TriggerCondition<T, P> {
    private AtlassianModuleProperties atlassianPlugin;
    private Map<String, String> config;

    public AnyTriggerCondition<T, P> atlassianPlugin(AtlassianModule atlassianPlugin) {
        this.atlassianPlugin = EntityPropertiesBuilders.build(atlassianPlugin);
        return this;
    }

    public AnyTriggerCondition<T, P> config(@NotNull Map<String, String> config) {
        this.config = Collections.unmodifiableMap(config);
        return this;
    }

    @Override
    protected P build() {
        return (P) new AnyTriggerConditionProperties(atlassianPlugin, config);
    }
}
