/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class AnyTaskProperties
extends TaskProperties {
    private final AtlassianModuleProperties atlassianPlugin;
    private final Map<String, String> configuration;

    private AnyTaskProperties() {
        this.atlassianPlugin = null;
        this.configuration = Collections.emptyMap();
    }

    public AnyTaskProperties(@NotNull AtlassianModuleProperties atlassianPlugin, String description, boolean isEnabled, Map<String, String> configuration, List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, isEnabled, requirements);
        this.atlassianPlugin = atlassianPlugin;
        this.configuration = Collections.unmodifiableMap(new LinkedHashMap<String, String>(configuration));
        this.validate();
    }

    @Override
    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return this.atlassianPlugin;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnyTaskProperties that = (AnyTaskProperties)o;
        return Objects.equals(this.getConfiguration(), that.getConfiguration());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getConfiguration());
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("atlassianPlugin", this.atlassianPlugin);
    }
}

