/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.trigger;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.trigger.AnyTriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AnyTrigger
extends RepositoryBasedTrigger<AnyTrigger, AnyTriggerProperties> {
    private AtlassianModuleProperties atlassianPlugin;
    private Map<String, String> configuration;

    public AnyTrigger(@NotNull AtlassianModule atlassianModule) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("atlassianModule", atlassianModule);
        this.atlassianPlugin = (AtlassianModuleProperties)EntityPropertiesBuilders.build(atlassianModule);
        this.configuration = new LinkedHashMap<String, String>();
    }

    public AnyTrigger(@NotNull AnyTrigger other) throws PropertiesValidationException {
        this(new AtlassianModule(other.atlassianPlugin.getCompleteModuleKey()));
        this.name = other.name;
        this.triggerEnabled = other.triggerEnabled;
        this.description = other.description;
        this.configuration(other.configuration);
    }

    public AnyTrigger configuration(Map<String, String> configuration) {
        this.configuration.putAll(configuration);
        return this;
    }

    @Override
    protected AnyTriggerProperties build() throws PropertiesValidationException {
        return new AnyTriggerProperties(this.atlassianPlugin, this.name, this.description, this.triggerEnabled, this.configuration, this.triggeringRepositoriesType, this.selectedTriggeringRepositories);
    }
}

