/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.docker;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerConfiguration
extends EntityPropertiesBuilder<DockerConfigurationProperties> {
    private boolean enabled = true;
    private String image;
    private boolean defaultVolumes = true;
    private Map<String, String> volumes = new LinkedHashMap<String, String>();

    public DockerConfiguration enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public DockerConfiguration image(@NotNull String image) {
        ImporterUtils.checkNotBlank("image", image);
        this.image = image;
        return this;
    }

    public DockerConfiguration withoutDefaultVolumes() {
        this.defaultVolumes = false;
        return this;
    }

    public DockerConfiguration volume(@NotNull String hostDirectory, @NotNull String containerDirectory) {
        ImporterUtils.checkNotBlank("hostDirectory", hostDirectory);
        ImporterUtils.checkNotBlank("containerDirectory", containerDirectory);
        if (this.volumes.containsKey(hostDirectory)) {
            throw new PropertiesValidationException(DockerConfigurationProperties.VALIDATION_CONTEXT, "Host directory " + hostDirectory + " is used by more than one volume.");
        }
        this.volumes.put(hostDirectory, containerDirectory);
        return this;
    }

    @Override
    protected DockerConfigurationProperties build() {
        LinkedHashMap<String, String> effectiveVolumes = new LinkedHashMap<String, String>();
        if (this.enabled && this.defaultVolumes) {
            effectiveVolumes.putAll(DockerConfigurationProperties.DEFAULT_VOLUMES);
        }
        effectiveVolumes.putAll(this.volumes);
        return new DockerConfigurationProperties(this.enabled, this.image, effectiveVolumes);
    }
}

