/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.repository;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGenIf;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.repository.SkipDisplayNameCondition;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import java.util.ArrayList;
import java.util.Objects;
import jdk.nashorn.internal.ir.annotations.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"repositoryName", "branchName"})
@Immutable
public class VcsRepositoryBranchProperties
implements EntityProperties {
    private String repositoryName;
    private String branchName;
    @SkipCodeGenIf(value=SkipDisplayNameCondition.class)
    private String branchDisplayName;

    private VcsRepositoryBranchProperties() {
    }

    public VcsRepositoryBranchProperties(@NotNull String repositoryName, @NotNull String branchName, @Nullable String branchDisplayName) {
        this.repositoryName = repositoryName;
        this.branchName = branchName;
        this.branchDisplayName = branchDisplayName;
        this.validate();
    }

    @NotNull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @NotNull
    public String getBranchName() {
        return this.branchName;
    }

    @Nullable
    public String getBranchDisplayName() {
        return this.branchDisplayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRepositoryBranchProperties that = (VcsRepositoryBranchProperties)o;
        return Objects.equals(this.getRepositoryName(), that.getRepositoryName()) && Objects.equals(this.getBranchName(), that.getBranchName()) && Objects.equals(this.getBranchDisplayName(), that.getBranchDisplayName());
    }

    public int hashCode() {
        return Objects.hash(this.getRepositoryName(), this.getBranchName(), this.getBranchDisplayName());
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Repository branch");
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        ImporterUtils.checkNotBlank("repositoryName", this.repositoryName);
        ImporterUtils.checkNotBlank("branchName", this.branchName);
        ValidationUtils.validateNotContainsShellInjectionRelatedCharacters(context.with("Branch name"), this.branchName).ifPresent(errors::add);
        ValidationUtils.validateNotContainsXssRelatedCharacters(context.with("Branch display name"), this.branchDisplayName).ifPresent(errors::add);
        ImporterUtils.checkNoErrors(errors);
    }
}

