/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.task;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.condition.TaskCondition;
import com.atlassian.bamboo.specs.api.builders.requirement.Requirement;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class Task<T extends Task<T, P>, P extends TaskProperties>
extends EntityPropertiesBuilder<P> {
    protected boolean taskEnabled = true;
    protected String description = "";
    protected List<ConditionProperties> conditions = new ArrayList<ConditionProperties>();
    protected List<RequirementProperties> requirements = new ArrayList<RequirementProperties>();

    protected Task() {
    }

    public T description(String description) {
        this.description = description;
        return (T)this;
    }

    public T enabled(boolean taskEnabled) {
        this.taskEnabled = taskEnabled;
        return (T)this;
    }

    public T requirements(Requirement ... requirements) {
        ImporterUtils.checkNotNull("requirements", requirements);
        Arrays.stream(requirements).map(EntityPropertiesBuilders::build).forEach(this.requirements::add);
        return (T)this;
    }

    public T conditions(TaskCondition<?> ... conditions) {
        ImporterUtils.checkNotNull("conditions", conditions);
        Arrays.stream(conditions).map(EntityPropertiesBuilders::build).forEach(this.conditions::add);
        return (T)this;
    }

    @Override
    @NotNull
    protected abstract P build();
}

