/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentClassLoader;
import com.atlassian.bamboo.agent.bootstrap.AgentRestarter;
import com.atlassian.bamboo.agent.bootstrap.AgentRunner;
import com.atlassian.bamboo.agent.bootstrap.AgentStoppageSupervisor;
import com.atlassian.bamboo.agent.bootstrap.GetFingerprintResponse;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentContext {
    public static AtomicBoolean restarting = new AtomicBoolean(false);
    private AgentRestarter restarter;
    private Thread restarterThread;
    private static final Logger log = Logger.getLogger(AgentContext.class);
    private final HttpClient httpClient;
    private volatile AgentRunner agentRunner;
    private final String baseUrl;
    private final String agentClassName;
    private final AgentClassLoader classLoader;
    private final String fingerprint;
    private final ThreadGroup threadGroup = new ThreadGroup(this.toString());
    private final AgentStoppageSupervisor stoppageSupervisor = new AgentStoppageSupervisor(this.threadGroup);
    private final Thread stoppageSupervisorThread = new Thread(this.stoppageSupervisor);
    private final Map<String, String> userProperties;

    static IOException httpException(int statusCode, String action) {
        return new IOException("HTTP status code " + statusCode + " received in response to " + action + ".");
    }

    private static void join(Thread thread) {
        try {
            thread.join();
        }
        catch (InterruptedException exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AgentContext(HttpClient httpClient, String baseUrl) throws IOException, ClassNotFoundException {
        String hostName;
        this.httpClient = httpClient;
        this.baseUrl = !baseUrl.endsWith("/") ? baseUrl + "/" : baseUrl;
        try {
            hostName = Inet4Address.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.warn("Cannot determine local host name; using \"localhost\".", e);
            hostName = "localhost";
        }
        GetMethod method = new GetMethod(this.baseUrl + "GetFingerprint.action?hostName=" + hostName);
        try {
            httpClient.executeMethod(method);
            int statusCode = method.getStatusCode();
            if (statusCode != 200) {
                throw AgentContext.httpException(statusCode, "fingerprint request");
            }
            GetFingerprintResponse fingerprintResponse = new GetFingerprintResponse(method.getResponseBodyAsStream());
            String bootstrapVersion = fingerprintResponse.getBootstrapVersion();
            if (bootstrapVersion == null) {
                throw new ProtocolException("Server has not specified Agent boostrap version.  Please re-install the agent.");
            }
            if (!bootstrapVersion.equals("1")) {
                throw new ProtocolException("Server requires Agent bootstrap version " + fingerprintResponse.getBootstrapVersion() + ".  Please re-install the agent.");
            }
            this.fingerprint = fingerprintResponse.getFingerprint();
            this.agentClassName = fingerprintResponse.getAgentClassName();
            this.userProperties = fingerprintResponse.getUserProperties();
        }
        finally {
            method.releaseConnection();
        }
        this.classLoader = new AgentClassLoader(this);
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    void run() {
        AgentRunner agentRunner;
        this.threadGroup.setDaemon(true);
        this.agentRunner = agentRunner = new AgentRunner(this, this.agentClassName);
        this.restarter = new AgentRestarter(agentRunner);
        this.restarterThread = new Thread(this.restarter);
        Thread thread = new Thread(this.threadGroup, agentRunner);
        thread.setContextClassLoader(this.getClassLoader());
        thread.start();
        AgentContext.join(thread);
        this.join();
        this.stoppageSupervisor.stop();
    }

    public Error restart(Throwable throwable) {
        log.info("Exiting Bamboo agent...", throwable);
        System.exit(1);
        throw new ThreadDeath();
    }

    String getAbsoluteURL(String relativeUrl) {
        String url = this.baseUrl + relativeUrl + "&fingerprint=" + this.fingerprint;
        log.debug("Requesting: " + url);
        return url;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    private void join() {
        Thread[] threadList = new Thread[1];
        while (this.threadGroup.enumerate(threadList) > 0) {
            AgentContext.join(threadList[0]);
        }
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }
}

