/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.bootstrap.AgentContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AgentBootstrap {
    private static final Logger log = Logger.getLogger(AgentBootstrap.class);
    private final String baseUrl;

    public static void main(String[] arguments) {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
        if (arguments.length == 1) {
            new AgentBootstrap(arguments[0]).run();
        } else {
            String message = "Incorrect command line syntax.  Please re-install the Bamboo Agent.";
            log.error("Incorrect command line syntax.  Please re-install the Bamboo Agent.");
            System.err.println("Incorrect command line syntax.  Please re-install the Bamboo Agent.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Error fatal(Throwable throwable) {
        try {
            log.error("Exiting due to fatal exception.", throwable);
        }
        finally {
            try {
                System.exit(1);
            }
            finally {
                throw new Error("System failed to exit.", throwable);
            }
        }
    }

    private AgentBootstrap(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    void run() {
        int waitTimeInSeconds = 30;
        try {
            Class.forName(HeadMethod.class.getName());
            HttpClient httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());
            while (true) {
                try {
                    new AgentContext(httpClient, this.baseUrl).run();
                    log.info("Remote agent stopped. Restarting in " + waitTimeInSeconds + " seconds.");
                }
                catch (Throwable t) {
                    log.error("Remote agent could not start. Retrying in " + waitTimeInSeconds + " seconds.", t);
                }
                Thread.sleep(waitTimeInSeconds * 1000);
            }
        }
        catch (Throwable throwable) {
            throw AgentBootstrap.fatal(throwable);
        }
    }
}

