/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.bamboo.utils.BambooLogger;
import com.atlassian.bamboo.utils.BambooThrowables;
import com.atlassian.bamboo.utils.collections.AlwaysInvalidatingCacheDecorator;
import com.atlassian.crowd.event.application.ApplicationDirectoryAddedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryOrderUpdatedEvent;
import com.atlassian.crowd.event.application.ApplicationDirectoryRemovedEvent;
import com.atlassian.crowd.event.application.ApplicationUpdatedEvent;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.user.User;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;

public class MembershipCache {
    private static final BambooLogger log = BambooLogger.getLogger(MembershipCache.class);
    private final LoadingCache<User, List<String>> cache;

    public MembershipCache(CacheLoader<User, List<String>> loader) {
        this.cache = AlwaysInvalidatingCacheDecorator.wrap((LoadingCache)CacheBuilder.newBuilder().build(loader));
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipsCreatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupCreatedEvent(GroupCreatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupUpdatedEvent(GroupUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onUserCreatedEvent(UserCreatedEvent ev) {
        this.resetUsers(ev, Collections.singletonList(ev.getUser().getName()));
    }

    @EventListener
    public void onUserEditedEvent(UserEditedEvent ev) {
        this.resetUsers(ev, Collections.singletonList(ev.getOriginalUser().getName()));
    }

    @EventListener
    public void onUserDeletedEvent(UsersDeletedEvent ev) {
        this.resetUsers(ev, ev.getUsernames());
    }

    @EventListener
    public void onUserRenamedEvent(UserRenamedEvent ev) {
        this.resetUsers(ev, Arrays.asList(ev.getOldUsername(), ev.getUser().getName()));
    }

    @EventListener
    public void onDirectoryDeletedEvent(DirectoryDeletedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onDirectoryUpdatedEvent(DirectoryUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onDirectoryCreatedEvent(DirectoryCreatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationDirectoryAddedEvent(ApplicationDirectoryAddedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationDirectoryRemovedEvent(ApplicationDirectoryRemovedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationDirectoryOrderUpdatedEvent(ApplicationDirectoryOrderUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @EventListener
    public void onApplicationUpdatedEvent(ApplicationUpdatedEvent ev) {
        this.resetCache(ev);
    }

    @Nullable
    public List<String> getGroupNamesAsList(User userName) {
        try {
            return (List)this.cache.get((Object)userName);
        }
        catch (ExecutionException e) {
            throw BambooThrowables.propagate((Throwable)e);
        }
    }

    private void resetCache(Object event) {
        log.debug("Invalidating the entire cache after receiving event: %s", new Object[]{event});
        this.cache.invalidateAll();
    }

    private void resetUsers(Object event, Collection<String> userNames) {
        log.debug("Invalidating cache for users %s after receiving event: %s", new Object[]{userNames, event});
        userNames.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }
}

