/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.atlassianuser.Conversions;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdGroupManager;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.impl.EntityValidationException;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.Pagers;
import com.atlassian.user.util.Assert;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EmbeddedCrowdGroupManagerImpl
implements EmbeddedCrowdGroupManager {
    private static final ThreadScopedCaches.Key<String, Iterable<Group>> CACHE_KEY = ThreadScopedCaches.makeKey(EmbeddedCrowdGroupManagerImpl.class);
    @Inject
    private RepositoryIdentifier repositoryIdentifier;
    @Inject
    private CrowdService crowdService;
    @Inject
    private CrowdDirectoryService crowdDirectoryService;
    @Inject
    private PermissionManager permissionManager;

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repositoryIdentifier;
        }
        return null;
    }

    public boolean isCreative() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(Directory::isActive).anyMatch(d -> this.permissionManager.hasPermission(d, OperationType.CREATE_GROUP));
    }

    public Pager<com.atlassian.user.Group> getGroups() throws EntityException {
        Iterable allGroups = this.crowdService.search((Query)Queries.ALL_GROUPS);
        return Pagers.newDefaultPager(Conversions.transform(allGroups, Conversions.TO_ATLASSIAN_GROUP));
    }

    public List<com.atlassian.user.Group> getWritableGroups() {
        Iterable allGroups = this.crowdService.search((Query)Queries.ALL_GROUPS);
        return Lists.newArrayList(Conversions.transform(allGroups, Conversions.TO_ATLASSIAN_GROUP));
    }

    public Pager<com.atlassian.user.Group> getGroups(com.atlassian.user.User user) {
        Iterable groupsForUser = (Iterable)ThreadScopedCaches.getValue(CACHE_KEY, (Object)user.getName(), () -> this.crowdService.search((Query)Queries.groupsForUser(user)));
        return Pagers.newDefaultPager(Conversions.transform(groupsForUser, Conversions.TO_ATLASSIAN_GROUP));
    }

    public Pager<String> getMemberNames(com.atlassian.user.Group group) throws EntityException {
        Iterable members = this.crowdService.search((Query)Queries.groupMemberNames(group));
        return Pagers.newDefaultPager((Iterable)members);
    }

    public Pager<String> getLocalMemberNames(com.atlassian.user.Group group) throws EntityException {
        return this.getMemberNames(group);
    }

    public Pager<String> getExternalMemberNames(com.atlassian.user.Group group) throws EntityException {
        return DefaultPager.emptyPager();
    }

    public com.atlassian.user.Group getGroup(String groupName) throws EntityException {
        if (groupName == null) {
            throw new IllegalArgumentException("Input (groupname) is null.");
        }
        return Conversions.TO_ATLASSIAN_GROUP.apply(this.crowdService.getGroup(groupName));
    }

    public com.atlassian.user.Group createGroup(String groupName) throws EntityException {
        Group group;
        try {
            group = this.crowdService.addGroup((Group)new ImmutableGroup(groupName));
        }
        catch (InvalidGroupException e) {
            throw new EntityValidationException((Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
        return Conversions.TO_ATLASSIAN_GROUP.apply(group);
    }

    public void removeGroup(com.atlassian.user.Group group) throws EntityException, IllegalArgumentException {
        try {
            this.crowdService.removeGroup(this.getCrowdGroup(group));
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void addMembership(com.atlassian.user.Group group, com.atlassian.user.User user) throws EntityException, IllegalArgumentException {
        Group crowdGroup = this.getCrowdGroup(group);
        if (crowdGroup == null) {
            throw new EntityException("This repository [" + this.getIdentifier().getName() + "] does not handle memberships of the group [" + group + "]");
        }
        User crowdUser = this.getCrowdUser(user);
        if (crowdUser == null) {
            throw new EntityException("This repository [" + this.getIdentifier().getName() + "] does not handle memberships of the user [" + user + "]");
        }
        try {
            this.crowdService.addUserToGroup(crowdUser, crowdGroup);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
    }

    public boolean hasMembership(com.atlassian.user.Group group, com.atlassian.user.User user) throws EntityException {
        Group crowdGroup = this.getCrowdGroup(group);
        if (crowdGroup == null) {
            return false;
        }
        User crowdUser = this.getCrowdUser(user);
        if (crowdUser == null) {
            return false;
        }
        return this.crowdService.isUserMemberOfGroup(crowdUser, crowdGroup);
    }

    public void removeMembership(com.atlassian.user.Group group, com.atlassian.user.User user) throws EntityException, IllegalArgumentException {
        Group crowdGroup = this.getCrowdGroup(group);
        if (crowdGroup == null) {
            throw new EntityException("This repository [" + this.getIdentifier().getName() + "] does not handle memberships of the group [" + group + "]");
        }
        User crowdUser = this.getCrowdUser(user);
        if (crowdUser == null) {
            throw new EntityException("This repository [" + this.getIdentifier().getName() + "] does not handle memberships of the user [" + user + "]");
        }
        try {
            this.crowdService.removeUserFromGroup(crowdUser, crowdGroup);
        }
        catch (OperationNotPermittedException e) {
            throw new EntityException((Throwable)e);
        }
        catch (CrowdRuntimeException e) {
            throw new EntityException((Throwable)e);
        }
    }

    private User getCrowdUser(com.atlassian.user.User user) {
        Assert.notNull((Object)user, (String)"User should not be null");
        if (user instanceof com.atlassian.crowd.model.user.User) {
            return (com.atlassian.crowd.model.user.User)user;
        }
        return this.crowdService.getUser(user.getName());
    }

    private Group getCrowdGroup(com.atlassian.user.Group group) {
        Assert.notNull((Object)group, (String)"Group should not be null");
        if (group instanceof Group) {
            return (Group)group;
        }
        return this.crowdService.getGroup(group.getName());
    }

    public boolean supportsExternalMembership() throws EntityException {
        return false;
    }

    public boolean isReadOnly(com.atlassian.user.Group group) throws EntityException {
        return false;
    }

    private static abstract class Queries {
        private static final EntityQuery<Group> ALL_GROUPS = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);

        private Queries() {
        }

        private static MembershipQuery<Group> groupsForUser(com.atlassian.user.User user) {
            return QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
        }

        private static MembershipQuery<String> groupMemberNames(com.atlassian.user.Group group) {
            return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1);
        }
    }
}

