/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.atlassianuser.CrowdSearchResult;
import com.atlassian.crowd.embedded.atlassianuser.QueryRestrictionConverter;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.user.EntityException;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.QueryValidator;
import javax.inject.Inject;
import org.jetbrains.annotations.Nullable;

public class EmbeddedCrowdEntityQueryParser
implements EntityQueryParser {
    @Inject
    private RepositoryIdentifier repositoryIdentifier;
    @Inject
    private CrowdService crowdService;
    private final QueryValidator queryValidator = new QueryValidator();
    private final QueryRestrictionConverter queryRestrictionConverter = new QueryRestrictionConverter();

    public SearchResult<com.atlassian.user.User> findUsers(Query<com.atlassian.user.User> query) throws EntityQueryException {
        this.queryValidator.assertValid(query);
        SearchRestriction restriction = this.queryRestrictionConverter.toRestriction(query);
        EntityQuery crowdQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)restriction, (int)0, (int)-1);
        return CrowdSearchResult.forUsers(this.repositoryIdentifier, this.crowdService.search((com.atlassian.crowd.embedded.api.Query)crowdQuery));
    }

    public SearchResult<com.atlassian.user.Group> findGroups(Query<com.atlassian.user.Group> query) throws EntityException {
        this.queryValidator.assertValid(query);
        SearchRestriction restriction = this.queryRestrictionConverter.toRestriction(query);
        EntityQuery crowdQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group(), (SearchRestriction)restriction, (int)0, (int)-1);
        return CrowdSearchResult.forGroups(this.repositoryIdentifier, this.crowdService.search((com.atlassian.crowd.embedded.api.Query)crowdQuery));
    }

    @Nullable
    public SearchResult<com.atlassian.user.User> findUsers(Query<com.atlassian.user.User> query, QueryContext context) throws EntityException {
        if (!context.contains(this.repositoryIdentifier)) {
            return null;
        }
        return this.findUsers(query);
    }

    @Nullable
    public SearchResult<com.atlassian.user.Group> findGroups(Query<com.atlassian.user.Group> query, QueryContext context) throws EntityException {
        if (!context.contains(this.repositoryIdentifier)) {
            return null;
        }
        return this.findGroups(query);
    }
}

