/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.seraph.filter.LoginFilter;
import com.atlassian.seraph.util.SecurityUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;

public class BambooLoginFilter
extends LoginFilter {
    protected static final Logger logger = Logger.getLogger(BambooLoginFilter.class);

    public void init(FilterConfig config) {
        super.init(config);
        this.setAllowUrlParameterValue(SystemProperty.ALLOW_URL_PARAMETERS_LOGIN.getTypedValue());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isAlreadyAuthenticated(servletRequest)) {
            SecurityUtils.disableSeraphFiltering((ServletRequest)servletRequest);
            servletRequest.setAttribute("os_securityfilter_already_filtered", (Object)true);
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            super.doFilter(servletRequest, servletResponse, filterChain);
        }
    }

    private boolean isAlreadyAuthenticated(ServletRequest request) {
        if ("success".equals(request.getAttribute("os_authstatus"))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"User IS authenticated via previous filter");
            }
            return true;
        }
        return false;
    }
}

