/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.accesstoken.AccessTokenAnalyticsService;
import com.atlassian.bamboo.accesstoken.AccessTokenService;
import com.atlassian.bamboo.security.AccessTokenContextHolder;
import com.atlassian.bamboo.spring.EventuallyAutowired;
import com.atlassian.bamboo.spring.EventuallyAutowiredSupport;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.seraph.auth.LoginReason;
import com.atlassian.seraph.filter.BaseLoginFilter;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AccessTokenLoginFilter
extends BaseLoginFilter {
    public static final String AUTHORIZED_BY_TOKEN = "authByAccessToken";
    public static final String ACCESS_TOKEN = "accessToken";
    private static final Logger log = Logger.getLogger(AccessTokenLoginFilter.class);
    private static final String BEARER = "Bearer";
    @EventuallyAutowired
    private EventuallyAvailable eventuallyAvailable;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        EventuallyAutowiredSupport.processInjectionBasedOnServletContext((Object)this, filterConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        try {
            super.doFilter(servletRequest, servletResponse, filterChain);
        }
        finally {
            AccessTokenContextHolder.clearContext();
            this.invalidateSession(httpServletRequest);
        }
    }

    public String login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean loggedIn = false;
        this.recordAuthenticationTry(httpServletRequest);
        Optional<String> bearerToken = this.getBearerToken(httpServletRequest);
        if (bearerToken.isPresent()) {
            log.debug((Object)"Try to authenticate with personal access token...");
            Optional authenticate = this.eventuallyAvailable.getAccessTokenService().authenticate(bearerToken.get());
            if (authenticate.isPresent()) {
                loggedIn = true;
                BambooUser bambooUser = this.eventuallyAvailable.getBambooUserManager().getBambooUser((AccessToken)authenticate.get());
                this.putPrincipalInSessionContext(httpServletRequest, bambooUser);
                log.debug((Object)"Authentication finished with success");
            } else {
                log.debug((Object)"Authentication finished with failure");
            }
        } else {
            log.debug((Object)"Could not find personal access token in request header");
        }
        if (loggedIn) {
            LoginReason.OK.stampRequestResponse(httpServletRequest, httpServletResponse);
        } else {
            LoginReason.AUTHENTICATED_FAILED.stampRequestResponse(httpServletRequest, httpServletResponse);
        }
        return loggedIn ? "success" : "failed";
    }

    private void recordAuthenticationTry(HttpServletRequest httpServletRequest) {
        String header = httpServletRequest.getHeader("Authorization");
        if (StringUtils.startsWith((CharSequence)header, (CharSequence)BEARER)) {
            this.eventuallyAvailable.getAccessTokenAnalyticsService().incrementTokenAuthenticationCount();
        } else if (StringUtils.startsWith((CharSequence)header, (CharSequence)"Basic") && !StringUtils.startsWith((CharSequence)httpServletRequest.getServletPath(), (CharSequence)"/rest/backdoor/")) {
            this.eventuallyAvailable.getAccessTokenAnalyticsService().incrementBasicAuthenticationCount();
        }
    }

    private Optional<String> getBearerToken(HttpServletRequest httpServletRequest) {
        String authorizationHeader = StringUtils.defaultString((String)httpServletRequest.getHeader("Authorization")).trim();
        if (authorizationHeader.startsWith(BEARER)) {
            return Optional.of(authorizationHeader.substring(BEARER.length() + 1).trim());
        }
        return Optional.empty();
    }

    protected void putPrincipalInSessionContext(HttpServletRequest httpServletRequest, BambooUser principal) {
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("seraph_defaultauthenticator_user", (Object)principal);
        httpSession.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        httpSession.setAttribute(AUTHORIZED_BY_TOKEN, (Object)true);
        httpSession.setAttribute(ACCESS_TOKEN, (Object)principal.getAccessToken());
        AccessTokenContextHolder.setContext((AccessTokenContextHolder.AccessTokenContext)new AccessTokenContextHolder.AccessTokenContext(principal.getAccessToken()));
    }

    protected void invalidateSession(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null && httpSession.getAttribute(AUTHORIZED_BY_TOKEN) != null) {
            httpSession.invalidate();
        }
    }

    private static class EventuallyAvailable {
        @Inject
        private AccessTokenService accessTokenService;
        @Inject
        private BambooUserManager bambooUserManager;
        @Inject
        private AccessTokenAnalyticsService accessTokenAnalyticsService;

        private EventuallyAvailable() {
        }

        public AccessTokenService getAccessTokenService() {
            return this.accessTokenService;
        }

        public BambooUserManager getBambooUserManager() {
            return this.bambooUserManager;
        }

        public AccessTokenAnalyticsService getAccessTokenAnalyticsService() {
            return this.accessTokenAnalyticsService;
        }
    }
}

