/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs.chain;

import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.opensymphony.xwork2.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class JobResultCrumb
extends BaseCrumb {
    private final List<BreadCrumb> crumbs = new ArrayList<BreadCrumb>();
    private boolean shown;
    private String id;
    private String label;
    private String url;

    public JobResultCrumb(HttpServletRequest request, Action action) {
        super(request, action);
        ResultsSummaryAware resultAware;
        ImmutablePlan plan;
        if (action instanceof ResultsSummaryAware && PlanClassHelper.isJob((ImmutablePlan)(plan = (resultAware = (ResultsSummaryAware)action).getImmutablePlan()))) {
            ImmutableJob job = (ImmutableJob)plan;
            this.shown = true;
            ResultsSummary summary = resultAware.getResultsSummary();
            this.id = summary.getPlanResultKey().toString();
            this.label = job.getBuildName();
            this.url = "/browse/" + summary.getPlanResultKey() + "/";
        }
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    public String getTitle() {
        return "Job";
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isCurrentPage() {
        return !this.isAnyChildShown();
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return this.crumbs;
    }
}

