/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs.chain;

import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.aware.BuildableAware;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.opensymphony.xwork2.Action;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class JobConfigCrumb
extends BaseCrumb {
    private static final Logger log = Logger.getLogger(JobConfigCrumb.class);
    private static final String CONFIG_ACTION = "/editBuildConfiguration.action";
    private static final String CONFIG_NAME_SPACE = "/build/admin/edit";
    private String url;
    private String label;
    private boolean shown = false;

    public JobConfigCrumb(HttpServletRequest request, Action action) {
        super(request, action);
        ImmutablePlan plan = null;
        if (action instanceof PlanAware) {
            PlanAware planAware = (PlanAware)action;
            plan = planAware.getImmutablePlan();
        } else if (action instanceof BuildableAware) {
            BuildableAware buildableAware = (BuildableAware)action;
            plan = buildableAware.getImmutableBuild();
        }
        if (plan != null && plan instanceof ImmutableBuildable) {
            this.label = plan.getBuildName();
            this.url = "/build/admin/edit/editBuildConfiguration.action?buildKey=" + plan.getKey();
            this.shown = this.isInCurrentPath(CONFIG_NAME_SPACE);
        }
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    @Override
    public boolean isCurrentPage() {
        return true;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return Collections.emptyList();
    }
}

