/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs.chain;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.atlassian.breadcrumbs.chain.JobResultCrumb;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Action;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public class ChainResultSummaryCrumb
extends BaseCrumb {
    private static final String VIEW_CHAIN_RESULTS = "viewChainResult";
    private final Collection<BreadCrumb> crumbs;
    private boolean shown;
    private String id;
    private String label;
    private String url;

    public ChainResultSummaryCrumb(HttpServletRequest request, Action action) {
        super(request, action);
        this.crumbs = Lists.newArrayList((Object[])new BreadCrumb[]{new JobResultCrumb(request, action)});
        if (action instanceof ResultsSummaryAware) {
            ResultsSummaryAware resultAware = (ResultsSummaryAware)action;
            ImmutablePlan plan = resultAware.getImmutablePlan();
            ResultsSummary summary = resultAware.getResultsSummary();
            if (summary instanceof ChainResultsSummary) {
                this.shown = true;
                this.id = summary.getPlanResultKey().toString();
                this.label = "#" + String.valueOf(summary.getBuildNumber());
                this.url = "/browse/" + summary.getPlanResultKey() + "/";
            } else if (PlanClassHelper.isJob((ImmutablePlan)plan)) {
                ImmutableJob job = (ImmutableJob)plan;
                ImmutableChain parent = job.getParent();
                String parentResultKey = parent.getKey() + "-" + summary.getBuildNumber();
                this.shown = true;
                this.id = parentResultKey;
                this.label = "#" + String.valueOf(summary.getBuildNumber());
                this.url = "/browse/" + parentResultKey + "/";
            }
        }
    }

    public Collection<BreadCrumb> getCrumbs() {
        return this.crumbs;
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isCurrentPage() {
        return this.isInCurrentPath(VIEW_CHAIN_RESULTS) || !this.isAnyChildShown();
    }

    public String getTitle() {
        return "Build";
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return this.crumbs;
    }
}

