/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs.chain;

import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.atlassian.breadcrumbs.BuildCrumb;
import com.atlassian.breadcrumbs.chain.ChainBranchesCrumb;
import com.atlassian.breadcrumbs.chain.ChainConfigCrumb;
import com.atlassian.breadcrumbs.chain.ChainResultSummaryCrumb;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Action;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ChainCrumb
extends BaseCrumb {
    private final List<BreadCrumb> crumbs;
    private boolean shown;
    private boolean disabled;
    private String id;
    private String label;
    private String url;

    public ChainCrumb(HttpServletRequest request, Action action) {
        super(request, action);
        this.crumbs = Lists.newArrayList((Object[])new BreadCrumb[]{new ChainResultSummaryCrumb(request, action), new ChainConfigCrumb(request, action), new ChainBranchesCrumb(request, action), new BuildCrumb(request, action)});
        if (action instanceof PlanAware) {
            PlanAware planAware = (PlanAware)action;
            ImmutablePlan plan = planAware.getImmutablePlan();
            if (PlanClassHelper.isChain((ImmutablePlan)plan)) {
                this.shown = true;
                this.id = plan.getKey();
                this.label = plan.getBuildName();
                this.url = "/browse/" + plan.getKey() + "/";
                this.disabled = plan.isSuspendedFromBuilding();
            } else if (PlanClassHelper.isJob((ImmutablePlan)plan)) {
                ImmutableJob job = (ImmutableJob)plan;
                ImmutableChain chain = job.getParent();
                this.shown = true;
                this.id = chain.getKey();
                this.label = chain.getBuildName();
                this.url = "/browse/" + chain.getKey() + "/";
                this.disabled = chain.isSuspendedFromBuilding();
            }
        }
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    public String getTitle() {
        return "Plan";
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isCurrentPage() {
        return !this.isAnyChildShown();
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return this.crumbs;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

