/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs.chain;

import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.atlassian.breadcrumbs.chain.JobConfigCrumb;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Action;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ChainConfigCrumb
extends BaseCrumb {
    private static final Logger log = Logger.getLogger(ChainConfigCrumb.class);
    private String url;
    private String label;
    private List<BreadCrumb> crumbs;
    private boolean shown;
    private static final String CONFIG_ACTION = "/editChainConfiguration.action";
    private static final String CONFIG_NAME_SPACE = "/chain/admin";

    public ChainConfigCrumb(HttpServletRequest request, Action action) {
        super(request, action);
        if (action instanceof PlanAware) {
            this.crumbs = Lists.newArrayList((Object[])new BreadCrumb[]{new JobConfigCrumb(request, action)});
            this.label = this.getText("breadCrumbs.chain.config");
            this.shown = this.isInCurrentPath(CONFIG_NAME_SPACE) || this.isAnyChildShown();
            PlanAware planAware = (PlanAware)action;
            ImmutablePlan plan = planAware.getImmutablePlan();
            if (PlanClassHelper.isChain((ImmutablePlan)plan)) {
                this.url = "/chain/admin/config/editChainConfiguration.action?planKey=" + plan.getKey();
            } else if (PlanClassHelper.isJob((ImmutablePlan)plan)) {
                this.url = "/chain/admin/config/editChainConfiguration.action?planKey=" + ((ImmutableJob)plan).getParent().getKey();
            }
        }
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    @Override
    public boolean isCurrentPage() {
        return !this.isAnyChildShown();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return this.crumbs;
    }
}

