/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs.build.result;

import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.opensymphony.xwork2.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BuildResultSummaryCrumb
extends BaseCrumb {
    private static final String VIEW_BUILD_RESULTS = "viewBuildResults";
    private final List<BreadCrumb> crumbs = new ArrayList<BreadCrumb>();

    public BuildResultSummaryCrumb(HttpServletRequest request, Action action) {
        super(request, action);
    }

    @Override
    public boolean isShown() {
        return this.action instanceof ResultsSummaryAware;
    }

    @Override
    public boolean isCurrentPage() {
        return this.isInCurrentPath(VIEW_BUILD_RESULTS) || !this.isAnyChildShown();
    }

    public String getTitle() {
        return "Build";
    }

    @Override
    public String getLabel() {
        ResultsSummaryAware buildAware = (ResultsSummaryAware)this.action;
        ResultsSummary buildResults = buildAware.getResultsSummary();
        if (buildResults != null) {
            int buildNumber = buildResults.getBuildNumber();
            return "#" + String.valueOf(buildNumber);
        }
        return "";
    }

    @Override
    public String getUrl() {
        ResultsSummaryAware buildAware = (ResultsSummaryAware)this.action;
        ResultsSummary buildResults = buildAware.getResultsSummary();
        if (buildResults != null) {
            return "/browse/" + buildResults.getPlanResultKey();
        }
        return "";
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return this.crumbs;
    }
}

