/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.bamboo.ww2.aware.ProjectAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.atlassian.breadcrumbs.BuildCrumb;
import com.atlassian.breadcrumbs.chain.ChainCrumb;
import com.opensymphony.xwork2.Action;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.Nullable;

public class ProjectCrumb
extends BaseCrumb {
    private static final String VIEW_PROJECT_SUMMARY_ACTION = "viewProject";
    private final List<BreadCrumb> crumbs;

    public ProjectCrumb(HttpServletRequest request, Action action) {
        super(request, action);
        this.crumbs = Arrays.asList(new ChainCrumb(request, action), new BuildCrumb(request, action));
    }

    @Override
    public boolean isShown() {
        return this.action instanceof ProjectAware || this.action instanceof PlanAware && this.getProject() != null;
    }

    public String getTitle() {
        return "Project";
    }

    @Nullable
    public String getId() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.getKey();
    }

    @Override
    @Nullable
    public String getLabel() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return project.getName();
    }

    @Override
    @Nullable
    public String getUrl() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return "/browse/" + project.getKey();
    }

    @Override
    public boolean isCurrentPage() {
        return this.isInCurrentPath(VIEW_PROJECT_SUMMARY_ACTION) || !this.isAnyChildShown();
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return this.crumbs;
    }

    @Nullable
    private Project getProject() {
        if (this.action instanceof ProjectAware) {
            ProjectAware projectAware = (ProjectAware)this.action;
            return projectAware.getProject();
        }
        if (this.action instanceof PlanAware) {
            PlanAware planAware = (PlanAware)this.action;
            ImmutablePlan plan = planAware.getImmutablePlan();
            if (plan == null) {
                return null;
            }
            return plan.getProject();
        }
        return null;
    }
}

