/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs;

import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.aware.BuildableAware;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.breadcrumbs.BaseCrumb;
import com.atlassian.breadcrumbs.BreadCrumb;
import com.atlassian.breadcrumbs.build.result.BuildResultSummaryCrumb;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Action;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BuildCrumb
extends BaseCrumb {
    private static final String VIEW_BUILD_SUMMARY_ACTION = "viewBuildSummary";
    private final List<BreadCrumb> crumbs;
    private boolean shown = false;
    private String id;
    private String label;
    private String url;
    private boolean disabled = false;

    public BuildCrumb(HttpServletRequest request, Action action) {
        super(request, action);
        this.crumbs = Lists.newArrayList((Object[])new BreadCrumb[]{new BuildResultSummaryCrumb(request, action)});
        ImmutablePlan plan = null;
        if (action instanceof PlanAware) {
            PlanAware planAware = (PlanAware)action;
            plan = planAware.getImmutablePlan();
        } else if (action instanceof BuildableAware) {
            BuildableAware buildableAware = (BuildableAware)action;
            plan = buildableAware.getImmutableBuild();
        }
        if (plan instanceof ImmutableBuildable) {
            this.shown = true;
            this.id = plan.getBuildKey();
            this.label = plan.getBuildName();
            this.url = "/browse/" + plan.getKey();
            this.disabled = plan.isSuspendedFromBuilding();
        }
    }

    @Override
    public boolean isShown() {
        return this.shown;
    }

    public String getTitle() {
        return this.getText("job.common.title");
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isCurrentPage() {
        return this.isInCurrentPath(VIEW_BUILD_SUMMARY_ACTION) || !this.isAnyChildShown();
    }

    @Override
    public Collection<BreadCrumb> getChildCrumbs() {
        return this.crumbs;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

