/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.breadcrumbs;

import com.atlassian.breadcrumbs.BreadCrumb;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.RequestUtils;

public abstract class BaseCrumb
implements BreadCrumb {
    private static final Logger log = Logger.getLogger(BaseCrumb.class);
    protected HttpServletRequest request;
    protected Action action;
    protected static final String BROWSE_PREFIX = "/browse/";
    protected static final String NUMBER_PREFIX = "#";

    public BaseCrumb(HttpServletRequest request, Action action) {
        this.request = request;
        this.action = action;
    }

    protected boolean isInCurrentPath(String path) {
        String servletContext = RequestUtils.getServletPath((HttpServletRequest)this.request);
        return servletContext != null && servletContext.contains(path);
    }

    protected String getText(String key) {
        TextProvider textProvider = (TextProvider)this.action;
        return textProvider.getText(key);
    }

    protected String createUrl(String actionName, String nameSpace, String key1, String value1) {
        return this.createUrl(actionName, nameSpace, key1, value1, null, null);
    }

    protected String createUrl(String actionName, String nameSpace, String key1, String value1, String key2, String value2) {
        StringBuilder s = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)nameSpace)) {
            s.append(nameSpace);
        }
        if (StringUtils.isEmpty((CharSequence)nameSpace) || !nameSpace.endsWith("/")) {
            s.append("/");
        }
        if (StringUtils.isNotEmpty((CharSequence)actionName)) {
            s.append(actionName).append(".action");
        }
        if (StringUtils.isNotEmpty((CharSequence)key1)) {
            s.append('?').append(key1).append('=').append(value1);
        }
        if (StringUtils.isNotEmpty((CharSequence)key2)) {
            s.append('&').append(key2).append('=').append(value2);
        }
        return s.toString();
    }

    protected boolean isAnyChildShown() {
        Collection<BreadCrumb> childCrumbs = this.getChildCrumbs();
        if (childCrumbs != null) {
            for (BreadCrumb crumb : childCrumbs) {
                if (!crumb.isShown()) continue;
                return true;
            }
        }
        return false;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public String getAccessKey() {
        return null;
    }

    public String getLabelWithAccessKeyUnderlined() {
        String key = this.getAccessKey();
        String label = StringEscapeUtils.escapeHtml4((String)this.getLabel());
        if (key != null && label != null) {
            StringBuilder sb = new StringBuilder();
            boolean underlined = false;
            for (int i = 0; i < label.length(); ++i) {
                String s = label.substring(i, i + 1);
                if (!underlined && key.equalsIgnoreCase(s)) {
                    sb.append("<u>");
                    sb.append(s);
                    sb.append("</u>");
                    underlined = true;
                    continue;
                }
                sb.append(s);
            }
            return sb.toString();
        }
        return label;
    }
}

