/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.results;

import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.aware.ReturnUrlAware;
import com.atlassian.bamboo.ww2.results.JSONAsHTMLResult;
import com.opensymphony.webwork.dispatcher.json.JSONResult;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.result.ServletRedirectResult;

public class ReturnableRedirectResult
extends ServletRedirectResult {
    private ObjectFactory objectFactory;

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        String successReturnMode = ReturnableRedirectResult.getSuccessReturnMode(invocation);
        if (successReturnMode.equals("json")) {
            Result json = this.objectFactory.buildResult(new ResultConfig.Builder("json", JSONResult.class.getName()).build(), invocation.getInvocationContext().getContextMap());
            json.execute(invocation);
        } else if (successReturnMode.equals("json-as-html")) {
            Result json = this.objectFactory.buildResult(new ResultConfig.Builder("stream", JSONAsHTMLResult.class.getName()).build(), invocation.getInvocationContext().getContextMap());
            json.execute(invocation);
        } else {
            String returnUrl;
            ReturnUrlAware action = (ReturnUrlAware)Narrow.downTo((Object)invocation.getAction(), ReturnUrlAware.class);
            if (action != null && StringUtils.isNotEmpty((CharSequence)(returnUrl = action.getReturnUrl()))) {
                finalLocation = returnUrl;
            }
            super.doExecute(finalLocation, invocation);
        }
    }

    private static String getSuccessReturnMode(ActionInvocation invocation) {
        return StringUtils.defaultString((String)ActionParamsUtils.getParameter(invocation.getInvocationContext(), "bamboo.successReturnMode"));
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

