/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.results;

import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.webwork.StrutsConfiguration;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.webwork.dispatcher.json.JSONResult;
import com.opensymphony.xwork2.ActionInvocation;
import io.atlassian.util.concurrent.Lazy;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JSONAsHTMLResult
extends JSONResult {
    private static final Logger log = Logger.getLogger(JSONAsHTMLResult.class);
    private static final String HTML_WITH_JSON_PRE = "<!DOCTYPE html><html><body><script type='application/json'>";
    private static final String HTML_WITH_JSON_POST = "</script></body></html>";
    private static final Supplier<Charset> CHARSET = Lazy.supplier(() -> Charset.forName(StrutsConfiguration.getEncoding()));
    public static final String CONTENT_TYPE = "text/html";

    public JSONAsHTMLResult() {
        this.setContentType(CONTENT_TYPE);
    }

    public void execute(ActionInvocation invocation) throws Exception {
        JSONObject jsonObject;
        if (log.isDebugEnabled()) {
            log.debug((Object)"executing JSONAsHTMLResult");
        }
        if ((jsonObject = this.getJSONObject(invocation)) == null) {
            return;
        }
        String jsonString = jsonObject.toString();
        byte[] pre = HTML_WITH_JSON_PRE.getBytes(CHARSET.get());
        byte[] json = EscapeChars.forScriptTag((String)jsonString).getBytes(CHARSET.get());
        byte[] post = HTML_WITH_JSON_POST.getBytes(CHARSET.get());
        HttpServletResponse response = this.getServletResponse(invocation);
        response.setContentType(this.getContentType() + ";charset=" + CHARSET.get().name());
        response.setContentLength(pre.length + json.length + post.length);
        ServletOutputStream os = response.getOutputStream();
        os.write(pre);
        os.write(json);
        os.write(post);
        os.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)("written [" + jsonString + "] to HttpServletResponse outputstream"));
        }
    }
}

