/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors.util;

import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ChainBranchRedirectHelper {
    private static final Map<String, String> branchForbiddenUrls = new HashMap<String, String>();
    private static final Map<String, String> lightweightBranchForbiddenUrls = new HashMap<String, String>();
    private static final Map<String, String> divergentBranchForbiddenUrls = new HashMap<String, String>();
    private static final String BRANCH_DETAILS_URL = "/branch/admin/config/editChainBranchDetails.action?planKey=";

    public static String getRedirectUrlIfNeeded(@NotNull String servletPath, @NotNull ImmutablePlan immutablePlan) {
        ImmutableChainBranch immutableChainBranch = (ImmutableChainBranch)Narrow.downTo((Object)immutablePlan, ImmutableChainBranch.class);
        if (immutableChainBranch == null) {
            return null;
        }
        Map<String, String> forbiddenUrls = immutableChainBranch.isDivergent() ? divergentBranchForbiddenUrls : lightweightBranchForbiddenUrls;
        for (Map.Entry<String, String> entry : forbiddenUrls.entrySet()) {
            if (!servletPath.startsWith(entry.getKey())) continue;
            return entry.getValue() + immutableChainBranch.getPlanKey().getKey();
        }
        return null;
    }

    static {
        branchForbiddenUrls.put("/chain/admin/config/editChainDetails.action", BRANCH_DETAILS_URL);
        branchForbiddenUrls.put("/chain/admin/config/configureBranches.action", BRANCH_DETAILS_URL);
        branchForbiddenUrls.put("/chain/admin/config/editChainDependencies.action", BRANCH_DETAILS_URL);
        branchForbiddenUrls.put("/chain/admin/config/editChainPermissions.action", BRANCH_DETAILS_URL);
        branchForbiddenUrls.put("/chain/admin/config/editChainMiscellaneous.action", BRANCH_DETAILS_URL);
        branchForbiddenUrls.put("/chain/admin/config/configureChainVariables.action", "/branch/admin/config/editChainBranchVariables.action?planKey=");
        branchForbiddenUrls.put("/chain/admin/config/editChainRepository.action", "/branch/admin/config/configureChainBranchRepositories.action?planKey=");
        lightweightBranchForbiddenUrls.putAll(branchForbiddenUrls);
        lightweightBranchForbiddenUrls.put("/chain/admin/config/defaultStages.action", BRANCH_DETAILS_URL);
        lightweightBranchForbiddenUrls.put("/chain/admin/config/editChainTriggers.action", BRANCH_DETAILS_URL);
        lightweightBranchForbiddenUrls.put("/chain/admin/config/defaultChainNotification.action", "/branch/admin/config/editChainBranchNotifications.action?planKey=");
        divergentBranchForbiddenUrls.putAll(branchForbiddenUrls);
        divergentBranchForbiddenUrls.put("/branch/admin/config/editChainBranchNotifications.action", "/chain/admin/config/defaultChainNotification.action?planKey=");
    }
}

