/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.xwork.interceptors.AroundInterceptor;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;
import org.jetbrains.annotations.Nullable;

public class TrimParametersInterceptor
extends AroundInterceptor {
    protected void before(ActionInvocation invocation) {
        HttpParameters parameters = invocation.getInvocationContext().getParameters();
        TrimParametersInterceptor.trimParameters(parameters);
    }

    protected void after(ActionInvocation dispatcher, String result) {
    }

    static void trimParameters(@Nullable HttpParameters parameters) {
        if (MapUtils.isEmpty((Map)parameters)) {
            return;
        }
        HashMap trimmedParameters = new HashMap();
        for (Map.Entry entry : parameters.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            Object paramValue = parameter.getObject();
            if (paramValue instanceof String) {
                String value = (String)paramValue;
                trimmedParameters.put(entry.getKey(), new Parameter.Request(parameter.getName(), (Object)StringUtils.trim((String)value)));
                continue;
            }
            if (!(paramValue instanceof String[])) continue;
            String[] values = (String[])paramValue;
            for (int i = 0; i < values.length; ++i) {
                values[i] = StringUtils.trim((String)values[i]);
            }
            trimmedParameters.put(entry.getKey(), new Parameter.Request(parameter.getName(), (Object)values));
        }
        parameters.appendAll(trimmedParameters);
    }
}

