/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.build.statistics.StatisticsCollector;
import com.atlassian.bamboo.build.statistics.StatisticsCollectorImpl;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.ww2.aware.StatisticsAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class StatisticsAwareInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(StatisticsAwareInterceptor.class);

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        StatisticsAware statisticsAware;
        ImmutablePlan plan;
        Object action = actionInvocation.getAction();
        if (action instanceof StatisticsAware && (plan = (statisticsAware = (StatisticsAware)action).getImmutablePlan()) != null) {
            ArrayList<? extends ResultsSummary> results = new ArrayList<ResultsSummary>(statisticsAware.getResultsList());
            StatisticsCollectorImpl statisticsCollector = new StatisticsCollectorImpl(plan, results);
            statisticsAware.setStatistics((StatisticsCollector)statisticsCollector);
        }
        return actionInvocation.invoke();
    }
}

