/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.struts.OgnlStackWrapper;
import com.atlassian.bamboo.utils.BambooIterators;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.BareBuildConfigurationAware;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;

public class SetBuildConfigToActionContext
implements PreResultListener {
    private static final String ARTIFACTS_ARTIFACT = "artifacts.artifact";

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        OgnlStackWrapper ognlStack = new OgnlStackWrapper(invocation);
        Map map = ognlStack.getContext();
        if (map == null) {
            return;
        }
        Object action = invocation.getAction();
        BuildConfiguration buildConfiguration = null;
        if (action instanceof BareBuildConfigurationAware) {
            BareBuildConfigurationAware aware = (BareBuildConfigurationAware)action;
            buildConfiguration = aware.getBuildConfiguration();
        }
        if (buildConfiguration != null) {
            ognlStack.putAll(this.generateStackContent(buildConfiguration));
        }
    }

    private Map<String, Object> generateStackContent(BuildConfiguration buildConfiguration) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BambooIterators.stream((Iterator)buildConfiguration.getKeys()).filter(SetBuildConfigToActionContext::isKeyNormalNode).forEach(key -> map.put((String)key, this.getValue((HierarchicalConfiguration)buildConfiguration, (String)key)));
        List nodes = buildConfiguration.configurationsAt(ARTIFACTS_ARTIFACT);
        int i = 0;
        for (HierarchicalConfiguration node : nodes) {
            Iterator iterator = node.getKeys();
            while (iterator.hasNext()) {
                String key2 = (String)iterator.next();
                Object value = this.getValue(node, key2);
                map.put("artifacts.artifact(" + i + ")." + key2, value);
            }
            ++i;
        }
        return map;
    }

    private static boolean isKeyNormalNode(String key) {
        return !StringUtils.contains((CharSequence)key, (CharSequence)ARTIFACTS_ARTIFACT);
    }

    private Object getValue(HierarchicalConfiguration buildConfiguration, String key) {
        int maxIndex = buildConfiguration.getMaxIndex(key);
        Object value = maxIndex > 0 ? buildConfiguration.getList(key) : buildConfiguration.getProperty(key);
        return value;
    }
}

