/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.ww2.aware.RssConfigurationAware;
import com.atlassian.bamboo.ww2.aware.permissions.DeploymentEnvironmentEditSecurityAware;
import com.atlassian.bamboo.ww2.aware.permissions.DeploymentProjectEditSecurityAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanAdminSecurityAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanEditSecurityAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.bamboo.ww2.interceptors.PlanInterceptorUtils;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.xwork2.ActionInvocation;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class RssConfigurationEditInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(RssConfigurationEditInterceptor.class);
    @VisibleForTesting
    static final String ERROR_RESULT = "fourOhOh";
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private PlanInterceptorUtils planInterceptorUtils;

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        Object action = actionInvocation.getAction();
        Pair<Boolean, Boolean> shouldBeValidatedPair = this.shouldBeValidated(action);
        boolean shouldBeValidated = (Boolean)shouldBeValidatedPair.getFirst();
        boolean invokedForAJob = (Boolean)shouldBeValidatedPair.getSecond();
        if (shouldBeValidated) {
            String methodName = actionInvocation.getProxy().getMethod();
            if (methodName == null) {
                methodName = "execute";
            }
            try {
                Method method = action.getClass().getMethod(methodName, new Class[0]);
                RssConfigurationAware annotation = method.getAnnotation(RssConfigurationAware.class);
                if (annotation != null && (!annotation.blockJobsOnly() || invokedForAJob)) {
                    String errorMessage = action.getClass().getName() + "." + methodName + "() tried to change entity managed by Bamboo Specs. Use code in Bamboo Specs repository to change plan or deployment";
                    log.error((Object)errorMessage);
                    this.addException(errorMessage);
                    return ERROR_RESULT;
                }
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.warn((Object)e.getMessage());
            }
        }
        return actionInvocation.invoke();
    }

    @VisibleForTesting
    protected void addException(String errorMessage) {
        ServletActionContext.getRequest().setAttribute("javax.servlet.error.exception", (Object)new IllegalStateException(errorMessage));
    }

    private Pair<Boolean, Boolean> shouldBeValidated(Object action) {
        DeploymentProject deploymentProject;
        Environment environment;
        boolean shouldBeValidated = false;
        boolean isJob = false;
        if (action instanceof PlanEditSecurityAware || action instanceof PlanAdminSecurityAware) {
            ImmutablePlan plan = this.planInterceptorUtils.findPlan(this);
            if (plan != null) {
                if (plan instanceof ImmutableChain) {
                    shouldBeValidated = ((ImmutableChain)plan).getVcsBambooSpecsSource() != null;
                } else if (plan instanceof ImmutableJob) {
                    isJob = true;
                    shouldBeValidated = plan.hasMaster() && !((ImmutableJob)plan).isDivergent() ? ((ImmutableJob)plan).getMaster().getParent().getVcsBambooSpecsSource() != null : ((ImmutableJob)plan).getParent().getVcsBambooSpecsSource() != null;
                }
            }
        } else if (action instanceof DeploymentProjectEditSecurityAware) {
            DeploymentProject deploymentProject2 = ((DeploymentProjectEditSecurityAware)action).getSecuredDomainObject();
            if (deploymentProject2 != null) {
                shouldBeValidated = deploymentProject2.isRepositorySpecsManaged();
            }
        } else if (action instanceof DeploymentEnvironmentEditSecurityAware && (environment = ((DeploymentEnvironmentEditSecurityAware)action).getSecuredDomainObject()) != null && (deploymentProject = this.deploymentProjectService.getDeploymentProject(environment.getDeploymentProjectId())) != null) {
            shouldBeValidated = deploymentProject.isRepositorySpecsManaged();
        }
        return Pair.make((Object)shouldBeValidated, (Object)isJob);
    }
}

