/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.Optional;
import org.apache.log4j.Logger;

public class ResultsSummaryAwareInteceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(ResultsSummaryAwareInteceptor.class);
    private static final String BUILD_NUMBER = "buildNumber";
    private ResultsSummaryManager resultsSummaryManager;

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        block8: {
            Object action = actionInvocation.getAction();
            if (action instanceof ResultsSummaryAware) {
                ResultsSummaryAware rsAware = (ResultsSummaryAware)action;
                String actionName = action.getClass().getCanonicalName();
                String buildKey = this.hasParameter("buildKey") ? this.getParameter("buildKey") : (this.hasParameter("planKey") ? this.getParameter("planKey") : (String)Optional.ofNullable(rsAware.getImmutablePlan()).map(ImmutablePlan::getKey).orElse(null));
                if (this.hasParameter(BUILD_NUMBER) && buildKey != null) {
                    try {
                        int buildNumber = Integer.parseInt(this.getParameter(BUILD_NUMBER));
                        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)buildKey, (int)buildNumber);
                        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
                        if (resultsSummary != null) {
                            rsAware.setResultsSummary(resultsSummary);
                            break block8;
                        }
                        log.warn((Object)("Action " + actionName + "' is resultsSummaryAware but no resultSummary can be found for " + planResultKey));
                    }
                    catch (NumberFormatException ex) {
                        log.warn((Object)("Invalid buildNumber value: " + this.getParameter(BUILD_NUMBER)));
                    }
                } else {
                    ResultsSummary resultsSummary = this.resultsSummaryManager.getLastResultsSummary(buildKey, ResultsSummary.class);
                    if (resultsSummary != null) {
                        rsAware.setResultsSummary(resultsSummary);
                    } else {
                        log.info((Object)("Action " + actionName + "' is resultsSummaryAware but no build number can be found for " + buildKey));
                    }
                }
            }
        }
        return actionInvocation.invoke();
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

