/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactory;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.ww2.aware.ResultsListAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ResultsListAwareInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(ResultsListAwareInterceptor.class);
    private FilterController filterController;
    private BuildResultsFilterFactory buildResultsFilterFactory;

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        ResultsListAware resultsListAware;
        ImmutablePlan plan;
        Object action = actionInvocation.getAction();
        if (action instanceof ResultsListAware && (plan = (resultsListAware = (ResultsListAware)action).getImmutablePlan()) != null) {
            List results = this.getFilter().getResultsForPlan(plan);
            resultsListAware.setResultsList(results);
        }
        return actionInvocation.invoke();
    }

    public BuildResultsFilter getFilter() {
        BuildResultsFilter filterByParameter;
        String parameter = this.getParameter("filterController.selectedFilterKey");
        if (!StringUtils.isEmpty((CharSequence)parameter) && (filterByParameter = this.buildResultsFilterFactory.getInstanceWithCookieKey(parameter)).getCookieKey().equalsIgnoreCase(parameter)) {
            return filterByParameter;
        }
        return this.buildResultsFilterFactory.getInstanceWithCookieKey(this.filterController.getSelectedFilterKey());
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    public void setBuildResultsFilterFactory(BuildResultsFilterFactory buildResultsFilterFactory) {
        this.buildResultsFilterFactory = buildResultsFilterFactory;
    }
}

