/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.build.creation.RepositoryConfigHelper;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.bamboo.ww2.aware.RepositoryConfigurationAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.bamboo.ww2.interceptors.InterceptorUtils;
import com.opensymphony.xwork2.ActionInvocation;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RepositoryConfigurationEditInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(RepositoryConfigurationEditInterceptor.class);

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        Object action = actionInvocation.getAction();
        RepositoryConfigurationAware repositoryConfigurationAware = (RepositoryConfigurationAware)Narrow.downTo((Object)action, RepositoryConfigurationAware.class);
        if (repositoryConfigurationAware != null) {
            try {
                this.injectData(repositoryConfigurationAware);
            }
            catch (RuntimeException e) {
                InterceptorUtils.addActionErrorOrThrow(repositoryConfigurationAware, e);
            }
        }
        return actionInvocation.invoke();
    }

    private void injectData(RepositoryConfigurationAware action) {
        RepositoryData repositoryData = action.getRepositoryById(this.findRepositoryId());
        if (repositoryData != null) {
            Repository repository = repositoryData.getRepository();
            XMLConfiguration config = RepositoryConfigHelper.prepareXmlConfiguration((Repository)repository, (WebRepositoryViewer)repositoryData.getWebRepositoryViewer());
            if (repositoryData.isGlobal() && action instanceof PlanAware) {
                config.setProperty("selectedRepository", (Object)Long.toString(repositoryData.getId()));
            } else {
                config.setProperty("selectedRepository", (Object)repository.getKey());
            }
            action.setRepositoryData(repositoryData);
            action.setBuildConfiguration(new BuildConfiguration((HierarchicalConfiguration)config));
        } else {
            action.setBuildConfiguration(new BuildConfiguration());
        }
    }

    private long findRepositoryId() {
        return Long.parseLong(StringUtils.defaultString((String)this.getParameter("repositoryId"), (String)"0"));
    }
}

