/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.Bamboo;
import com.atlassian.bamboo.rest.BambooRemoteException;
import com.atlassian.bamboo.rest.Login;
import com.atlassian.bamboo.rest.SessionManager;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.RestActionAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class RemoteApiLoginInterceptor
extends AbstractBambooInterceptor {
    private BambooUserManager bambooUserManager;
    private Bamboo bamboo;

    @Override
    public String doIntercept(final ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if ((action instanceof RestActionAware || action instanceof Login) && action instanceof BambooActionSupport) {
            BambooActionSupport restAction = (BambooActionSupport)action;
            if (!(action instanceof Login)) {
                BambooUser bambooUser;
                if (StringUtils.isEmpty((CharSequence)this.getSessionId())) {
                    restAction.addActionError("You need to provide an auth id");
                    return "error";
                }
                String userNameFromSession = this.getUserNameFromSession();
                if (userNameFromSession != null && (bambooUser = this.bambooUserManager.loadUserByUsername(userNameFromSession)) != null) {
                    final AtomicReference result = new AtomicReference();
                    BambooRunnables.Throwing1<Exception> actionInvocation = new BambooRunnables.Throwing1<Exception>(){

                        public void run() throws Exception {
                            result.set(invocation.invoke());
                        }
                    };
                    ImpersonationHelper.runAs((BambooUser)bambooUser, (BambooRunnables.ThrowingX)actionInvocation);
                    return (String)result.get();
                }
                restAction.addActionError("User not authenticated yet, or session timed out.");
                return "error";
            }
            return invocation.invoke();
        }
        return invocation.invoke();
    }

    protected String getUserNameFromSession() {
        SessionManager sessionManager = this.getBamboo().getSessionManager();
        try {
            String sessionId = this.getSessionId();
            if (sessionId != null) {
                return sessionManager.getUserNameFromSession(sessionId);
            }
            return null;
        }
        catch (BambooRemoteException e) {
            return null;
        }
    }

    public Bamboo getBamboo() {
        if (this.bamboo == null) {
            this.bamboo = (Bamboo)ActionContext.getContext().getApplication().get("com.atlassian.bamboo.Bamboo");
        }
        return this.bamboo;
    }

    public void setBamboo(Bamboo bamboo) {
        this.bamboo = bamboo;
    }

    private String getSessionId() {
        return this.getParameter("auth");
    }

    public BambooUserManager getBambooUserManager() {
        return this.bambooUserManager;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }
}

