/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.rest.Login;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.RestActionAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.opensymphony.xwork2.ActionInvocation;
import org.apache.log4j.Logger;

public class RemoteApiExceptionInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(RemoteApiExceptionInterceptor.class);

    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if ((action instanceof RestActionAware || action instanceof Login) && action instanceof BambooActionSupport) {
            BambooActionSupport restAction = (BambooActionSupport)action;
            try {
                return invocation.invoke();
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception during processing of REST request.", (Throwable)e);
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = e.getClass().getName();
                }
                restAction.addActionError(errorMessage);
                return "error";
            }
        }
        return invocation.invoke();
    }
}

