/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.aware.BuildableAware;
import com.atlassian.bamboo.ww2.aware.ChainAware;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.atlassian.xwork.interceptors.AroundInterceptor;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlanAwareInterceptor
extends AroundInterceptor {
    private static final Logger log = Logger.getLogger(PlanAwareInterceptor.class);
    private static final String BUILD_SESSION_KEY = "bamboo.session.plan.last.key";
    private CachedPlanManager cachedPlanManager;
    private CustomVariableContext customVariableContext;

    protected void before(ActionInvocation actionInvocation) {
        block18: {
            try (Ticker ticker = Timers.start((String)"PlanAwareInterceptor.intercept()");){
                String planKey;
                Object action = actionInvocation.getAction();
                if (!(action instanceof PlanAware) && !(action instanceof BuildableAware) && !(action instanceof ChainAware) || !StringUtils.isNotEmpty((CharSequence)(planKey = this.getPlanKey()))) break block18;
                try {
                    ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey), ImmutablePlan.class);
                    if (plan != null) {
                        this.customVariableContext.setPlan(plan);
                        if (action instanceof PlanAware) {
                            ((PlanAware)action).setPlan(plan);
                        }
                        ImmutableBuildable buildable = (ImmutableBuildable)Narrow.to((Object)plan, ImmutableBuildable.class);
                        if (action instanceof BuildableAware && buildable != null) {
                            ((BuildableAware)action).setBuild(buildable);
                        }
                        Chain chain = (Chain)Narrow.to((Object)plan, Chain.class);
                        if (action instanceof ChainAware && chain != null) {
                            ((ChainAware)action).setChain((ImmutableChain)chain);
                        }
                        break block18;
                    }
                    log.warn((Object)("Action '" + action + "' is plan aware but no plan can be found. PlanKey was '" + planKey + "'"));
                }
                catch (IncorrectPlanTypeException | IllegalArgumentException ex) {
                    log.warn((Object)("Action '" + action + "' is plan aware but invalid plan key found. PlanKey was '" + planKey + "'"));
                }
            }
        }
    }

    protected void after(ActionInvocation dispatcher, @Nullable String result) {
        if (this.customVariableContext != null) {
            this.customVariableContext.clearContext();
        }
    }

    @Nullable
    private String getPlanKey() {
        String planKey = null;
        if (this.hasParameter("planKey")) {
            planKey = this.getParameter("planKey");
        } else if (this.hasParameter("buildKey")) {
            planKey = this.getParameter("buildKey");
        } else if (this.hasParameter("planResultKey")) {
            String planResultKey = this.getParameter("planResultKey");
            PlanResultKey resultKey = PlanKeys.getPlanResultKey((String)planResultKey);
            return resultKey.getPlanKey().getKey();
        }
        if (planKey == null && ActionContext.getContext().getSession().containsKey(BUILD_SESSION_KEY)) {
            planKey = (String)ActionContext.getContext().getSession().get(BUILD_SESSION_KEY);
        }
        return planKey;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    protected String getParameter(String parameterName) {
        return ActionParamsUtils.getParameter(parameterName);
    }

    protected boolean hasParameter(String parameterName) {
        return ActionParamsUtils.hasParameter(parameterName);
    }
}

