/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.utils.BambooUrl;
import com.atlassian.bamboo.ww2.aware.LazyPaginationAware;
import com.atlassian.bamboo.ww2.aware.PaginationAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;

public class PaginationAwareInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(PaginationAwareInterceptor.class);

    @Override
    public String doIntercept(final ActionInvocation actionInvocation) throws Exception {
        actionInvocation.addPreResultListener(new PreResultListener(){

            public void beforeResult(ActionInvocation invocation, String result) {
                try (Ticker ticker = Timers.start((String)"PaginationAwareInterceptor.intercept()");){
                    Object action = actionInvocation.getAction();
                    if (action instanceof PaginationAware) {
                        PaginationAware paginationAware = (PaginationAware)action;
                        Pager pager = paginationAware.getPager();
                        if (pager == null) {
                            pager = new Pager();
                            paginationAware.setPager(pager);
                        }
                        int pageIndex = PaginationAwareInterceptor.this.getParameterAsInt("pageIndex");
                        int pageSize = PaginationAwareInterceptor.this.getParameterAsInt("pageSize");
                        if (pageIndex > -1) {
                            pager.setPageIndex(pageIndex);
                        }
                        if (pageSize > -1) {
                            pager.setPageSize(pageSize);
                        }
                        pager.setUrlString(BambooUrl.getCurrentPathAndQuery());
                        List list = paginationAware.getResultsList();
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            pager.setPageFromList(list);
                        }
                    } else if (action instanceof LazyPaginationAware) {
                        LazyPaginationAware paginationAware = (LazyPaginationAware)action;
                        Pager pager = paginationAware.getPager();
                        if (pager == null) {
                            pager = new Pager();
                            paginationAware.setPager(pager);
                        }
                        int pageIndex = PaginationAwareInterceptor.this.getParameterAsInt("pageIndex");
                        int pageSize = PaginationAwareInterceptor.this.getParameterAsInt("pageSize");
                        if (pageIndex > -1) {
                            pager.setPageIndex(pageIndex);
                        }
                        if (pageSize > -1) {
                            pager.setPageSize(pageSize);
                        }
                        pager.setUrlString(BambooUrl.getCurrentPathAndQuery());
                        int totalCount = paginationAware.getResultsCount();
                        List list = paginationAware.getFilteredResultsList(pager.getPageIndex() * pager.getPageSize(), pager.getPageSize());
                        pager.setPageFromFilteredList(list, totalCount);
                    }
                }
            }
        });
        return actionInvocation.invoke();
    }
}

