/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.struts.OgnlStackWrapper;
import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.NavigationContext;
import com.atlassian.bamboo.ww2.aware.NavigationAware;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObject;
import com.atlassian.bamboo.ww2.beans.DecoratedNavObjectFactory;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.bamboo.ww2.interceptors.util.ChainBranchRedirectHelper;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.Nullable;

public class NavigationAwareInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(NavigationAwareInterceptor.class);
    private static final String HEADER_X_PLAN_URL = "X-Plan-URL";
    private static final String HEADER_X_JOB_URL = "X-Job-URL";
    private DecoratedNavObjectFactory decoratedNavObjectFactory;
    private CachedPlanManager cachedPlanManager;
    private ResultsSummaryManager resultsSummaryManager;
    private CustomVariableContext customVariableContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        try {
            if (action instanceof NavigationAware) {
                NavigationAware navigationAction;
                PlanAware planAware;
                ImmutablePlan plan;
                log.debug((Object)("Finding Navigation Objects for " + action.getClass().getCanonicalName()));
                if (action instanceof PlanAware && (plan = (planAware = (PlanAware)action).getImmutablePlan()) != null) {
                    String redirectUrl = ChainBranchRedirectHelper.getRedirectUrlIfNeeded(ServletActionContext.getRequest().getServletPath(), plan);
                    if (redirectUrl != null) {
                        OgnlStackWrapper ognlStack = new OgnlStackWrapper(invocation);
                        ognlStack.putAll(Collections.singletonMap("navigationRedirectUrl", redirectUrl));
                        String string = "navigationAwareRedirect";
                        return string;
                    }
                    this.customVariableContext.setPlan(plan);
                }
                if ((navigationAction = (NavigationAware)action).getNavigationContext() == null) {
                    HttpServletRequest servletRequest = ServletActionContext.getRequest();
                    String url = (String)servletRequest.getAttribute("originalUrl");
                    if (url == null) {
                        url = navigationAction.getNavigationUrl();
                    }
                    if (url != null) {
                        url = UrlUtils.sanitizeUri((String)url);
                        DecoratedNavObject decoratedNavObject = this.getNavObject(navigationAction);
                        if (decoratedNavObject != null) {
                            NavigationContext navigationContext = new NavigationContext(url, decoratedNavObject, navigationAction.getJobEquiv(), navigationAction.getChainEquiv());
                            navigationAction.setNavigationContext(navigationContext);
                            HttpServletResponse servletResponse = ServletActionContext.getResponse();
                            String historyXHRHeader = servletRequest.getHeader("X-History-XHR");
                            if (servletResponse != null && Boolean.parseBoolean(historyXHRHeader)) {
                                DecoratedNavObject navObject = navigationContext.getNavObject();
                                String chainUrl = navigationContext.getChainUrl(navObject);
                                String jobUrl = navigationContext.getJobUrl(navObject);
                                if (chainUrl != null) {
                                    servletResponse.setHeader(HEADER_X_PLAN_URL, chainUrl);
                                }
                                if (jobUrl != null) {
                                    servletResponse.setHeader(HEADER_X_JOB_URL, jobUrl);
                                }
                            }
                        }
                    }
                }
            }
            String string = invocation.invoke();
            return string;
        }
        finally {
            if (this.customVariableContext != null) {
                this.customVariableContext.clearContext();
            }
        }
    }

    @Nullable
    private DecoratedNavObject getNavObject(NavigationAware action) {
        PlanAware planAware;
        ImmutablePlan plan;
        ResultsSummaryAware rsAware;
        ResultsSummary summary;
        if (action instanceof ResultsSummaryAware && (summary = (rsAware = (ResultsSummaryAware)((Object)action)).getResultsSummary()) != null) {
            return this.decoratedNavObjectFactory.decorateResult(summary);
        }
        if (action instanceof PlanAware && (plan = (planAware = (PlanAware)((Object)action)).getImmutablePlan()) != null) {
            return this.decoratedNavObjectFactory.decoratePlan(plan);
        }
        String planKey = StringUtils.defaultString((String)this.getParameter("buildKey"), (String)this.getParameter("planKey"));
        if (StringUtils.isBlank((CharSequence)planKey)) {
            return null;
        }
        try {
            ResultsSummary resultsSummary;
            int buildNumber;
            String buildNumberParam = this.getParameter("buildNumber");
            if (StringUtils.isNumeric((CharSequence)buildNumberParam) && (buildNumber = Integer.parseInt(buildNumberParam)) > 0 && (resultsSummary = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)planKey, (int)buildNumber))) != null) {
                return this.decoratedNavObjectFactory.decorateResult(resultsSummary);
            }
            PlanKey validPlanKey = PlanKeys.getPlanKey((String)planKey);
            ImmutablePlan plan2 = this.cachedPlanManager.getPlanByKey(validPlanKey);
            if (plan2 != null) {
                return this.decoratedNavObjectFactory.decoratePlan(plan2);
            }
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Plan key not valid: " + planKey), (Throwable)e);
        }
        return null;
    }

    public void setDecoratedNavObjectFactory(DecoratedNavObjectFactory decoratedNavObjectFactory) {
        this.decoratedNavObjectFactory = decoratedNavObjectFactory;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

