/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.common.JsonHelper;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.struts.ValidationAware;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Validateable;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class JSONValidationInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(JSONValidationInterceptor.class);
    public static final String VALIDATE_JSON_PARAM = "bamboo.enableJSONValidation";

    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();
        Object action = invocation.getAction();
        String jsonEnabled = request.getParameter(VALIDATE_JSON_PARAM);
        if (Boolean.parseBoolean(jsonEnabled)) {
            if (action instanceof Validateable && action instanceof ValidationAware) {
                ValidationAware validationAware = (ValidationAware)action;
                Validateable validateable = (Validateable)action;
                validateable.validate();
                if (validationAware.hasErrors()) {
                    JsonHelper.returnJsonResponse(response, this.buildResponse(validationAware));
                } else {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("status", (Object)BambooActionSupport.JSONStatus.OK);
                    JsonHelper.returnJsonResponse(response, jsonObject);
                }
                return "none";
            }
            return invocation.invoke();
        }
        return invocation.invoke();
    }

    protected JSONObject buildResponse(ValidationAware validationAware) throws JSONException {
        JSONObject result = new JSONObject();
        if (validationAware.hasErrors()) {
            result.put("status", (Object)BambooActionSupport.JSONStatus.ERROR);
            if (validationAware.hasActionErrors()) {
                result.put("errors", validationAware.getActionErrors());
            }
            if (validationAware.hasFieldErrors()) {
                JSONObject jsonFieldErrors = new JSONObject();
                Map fieldErrors = validationAware.getFieldErrors();
                for (Map.Entry fieldError : fieldErrors.entrySet()) {
                    String key = validationAware instanceof ModelDriven ? ((String)fieldError.getKey()).substring(6) : (String)fieldError.getKey();
                    jsonFieldErrors.put(key, (Collection)fieldError.getValue());
                }
                result.put("fieldErrors", (Object)jsonFieldErrors);
            }
        }
        return result;
    }
}

