/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FieldErrorUsageVerifier
implements Interceptor {
    private static final Logger log = Logger.getLogger(FieldErrorUsageVerifier.class);

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        ValidationAware validationAwareAction = (ValidationAware)Narrow.downTo((Object)invocation.getAction(), ValidationAware.class);
        if (validationAwareAction == null) {
            return invocation.invoke();
        }
        Map existingFieldErrors = Collections.emptyMap();
        try {
            existingFieldErrors = new HashMap(validationAwareAction.getFieldErrors());
            String string = invocation.invoke();
            return string;
        }
        finally {
            if (validationAwareAction.hasErrors()) {
                HashMap<String, List<String>> newErrors = new HashMap<String, List<String>>(validationAwareAction.getFieldErrors());
                newErrors.keySet().removeAll(existingFieldErrors.keySet());
                this.checkIfAllFieldErrorsWereAccessed(validationAwareAction, newErrors);
            }
        }
    }

    private void checkIfAllFieldErrorsWereAccessed(ValidationAware validationAwareAction, Map<String, List<String>> fieldErrors) {
        BambooActionSupport bambooActionSupport = (BambooActionSupport)Narrow.downTo((Object)validationAwareAction, BambooActionSupport.class);
        if (bambooActionSupport == null) {
            return;
        }
        Set<String> fieldErrorAccessTracker = bambooActionSupport.getFieldErrorAccessTracker();
        Sets.SetView unaccessedFieldErrors = Sets.difference(fieldErrors.keySet(), fieldErrorAccessTracker);
        for (String unaccessedField : unaccessedFieldErrors) {
            log.error((Object)(validationAwareAction.getClass().getSimpleName() + ": unreported field errors: " + unaccessedField + " : " + fieldErrors.get(unaccessedField)));
        }
    }
}

