/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.ww2.aware.JsonStatusProvider;
import com.atlassian.bamboo.ww2.common.JsonHelper;
import com.atlassian.bamboo.ww2.interceptors.StatusCheckRequestHelper;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.BackgroundProcess;
import org.apache.struts2.interceptor.ExecuteAndWaitInterceptor;

public class ExecAndWaitWithJSONStatusUpdateInterceptor
extends ExecuteAndWaitInterceptor {
    private static final Logger log = Logger.getLogger(ExecAndWaitWithJSONStatusUpdateInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        if (StatusCheckRequestHelper.isStatusCheckRequest(request)) {
            Map session;
            String name = actionInvocation.getProxy().getActionName();
            Map map = session = actionInvocation.getInvocationContext().getSession();
            synchronized (map) {
                BackgroundProcess bp = (BackgroundProcess)session.get("__execWait" + name);
                if (bp == null) {
                    JSONObject jsonObject = new JSONObject();
                    JsonHelper.returnJsonResponse(ServletActionContext.getResponse(), jsonObject);
                    log.info((Object)("Bypassing a completed/not started action " + name + ", this is purely a status request"));
                    return "none";
                }
                Object actionObject = bp.getAction();
                if (actionObject instanceof JsonStatusProvider) {
                    log.debug((Object)("Bypassing action: " + name + ", this is purely a status request"));
                    JsonStatusProvider action = (JsonStatusProvider)actionObject;
                    JSONObject jsonObject = action.getJsonStatus();
                    JsonHelper.returnJsonResponse(ServletActionContext.getResponse(), jsonObject);
                    return "none";
                }
                log.warn((Object)("ExecAndWaitWithJSONStatusUpdateInterceptor applied to action " + name + " that is not a JsonStatusProvider. Consider using ExecuteAndWaitInterceptor instead."));
            }
        }
        return super.intercept(actionInvocation);
    }
}

