/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.plugin.xwork.PluginAwareActionConfig;
import com.atlassian.bamboo.struts.OgnlStackWrapper;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.ConditionallyAvailable;
import com.atlassian.bamboo.ww2.interceptors.SecurityRelatedInterceptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.web.Condition;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@SecurityRelatedInterceptor
public class ConditionalActionInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(ConditionalActionInterceptor.class);
    @Autowired
    private HostContainer hostContainer;

    @VisibleForTesting
    void setHostContainer(HostContainer hostContainer) {
        this.hostContainer = hostContainer;
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Condition condition;
        Annotation annotation;
        Class<?> actionClass = invocation.getAction().getClass();
        String actionName = invocation.getProxy().getActionName();
        Map invocationContext = new OgnlStackWrapper(invocation).getContext();
        if (actionClass.isAnnotationPresent(ConditionallyAvailable.class)) {
            annotation = actionClass.getAnnotation(ConditionallyAvailable.class);
            for (Class<? extends Condition> conditionClass : annotation.condition()) {
                condition = this.loadCondition(invocation, conditionClass);
                condition.init(Collections.emptyMap());
                if (condition.shouldDisplay(invocationContext)) continue;
                log.info((Object)String.format("Access to action %s was blocked by condition %s", actionName, condition.getClass().getName()));
                return "fourOhFour";
            }
        }
        if (actionClass.isAnnotationPresent(ConditionallyAccessible.class)) {
            annotation = actionClass.getAnnotation(ConditionallyAccessible.class);
            for (Class<? extends Condition> conditionClass : annotation.condition()) {
                condition = this.loadCondition(invocation, conditionClass);
                condition.init(Collections.emptyMap());
                if (condition.shouldDisplay(invocationContext)) continue;
                log.info((Object)String.format("Access to action %s was blocked by condition %s", actionName, condition.getClass().getName()));
                return "accessDenied";
            }
        }
        return invocation.invoke();
    }

    @NotNull
    private Condition loadCondition(@NotNull ActionInvocation invocation, @NotNull Class<? extends Condition> conditionClass) {
        Plugin plugin;
        ActionConfig actionConfig = invocation.getProxy().getConfig();
        if (actionConfig instanceof PluginAwareActionConfig && (plugin = ((PluginAwareActionConfig)actionConfig).getPlugin()) instanceof ContainerManagedPlugin) {
            return (Condition)((ContainerManagedPlugin)plugin).getContainerAccessor().createBean(conditionClass);
        }
        return (Condition)this.hostContainer.create(conditionClass);
    }
}

