/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.aware.ChainAware;
import com.atlassian.bamboo.ww2.aware.PlanAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.opensymphony.xwork2.ActionInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.Nullable;

public class ChainAwareInterceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(ChainAwareInterceptor.class);
    private static final String CHAIN_KEY_PARAM = "buildKey";
    private static final String STAGE_ID_PARAM = "stageId";
    private static final String RESULT_ID_PARAM = "buildNumber";
    private PlanManager planManager;
    private ResultsSummaryManager resultsSummaryManager;

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        block21: {
            try (Ticker ticker = Timers.start((String)"ChainAwareInterceptor.intercept()");){
                Object action = actionInvocation.getAction();
                Chain chain = null;
                if (!(action instanceof ChainAware)) break block21;
                ChainAware chainAware = (ChainAware)action;
                if (action instanceof PlanAware) {
                    ImmutablePlan plan = ((PlanAware)action).getImmutablePlan();
                    chain = (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class);
                }
                if (chain == null) {
                    chain = this.findChain();
                }
                if (chain != null) {
                    block22: {
                        chainAware.setChain((ImmutableChain)chain);
                        String stageId = this.getParameter(STAGE_ID_PARAM);
                        try {
                            if (!StringUtils.isNotEmpty((CharSequence)stageId)) break block22;
                            long val = Long.parseLong(stageId);
                            for (ImmutableChainStage stage : chain.getStages()) {
                                if (stage.getId() != val) continue;
                                chainAware.setChainStage(stage);
                                break;
                            }
                        }
                        catch (NumberFormatException e) {
                            log.error((Object)"Could not parse stageId", (Throwable)e);
                        }
                    }
                    String resultId = this.getParameter(RESULT_ID_PARAM);
                    try {
                        if (StringUtils.isNotEmpty((CharSequence)resultId)) {
                            int val = Integer.parseInt(resultId);
                            ChainResultsSummary chainResult = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)chain.getPlanKey(), (int)val), ChainResultsSummary.class);
                            chainAware.setChainResult(chainResult);
                            chainAware.setChainResultNumber(val);
                        }
                        break block21;
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)"Could not parse stageId", (Throwable)e);
                    }
                    break block21;
                }
                log.warn((Object)("Action '" + action + "' is ChainAware but no build chain can be found. ChainKey: " + this.getParameter(CHAIN_KEY_PARAM)));
            }
        }
        return actionInvocation.invoke();
    }

    @Nullable
    private Chain findChain() {
        String planKey = null;
        if (this.hasParameter("planKey")) {
            planKey = this.getParameter("planKey");
        } else if (this.hasParameter(CHAIN_KEY_PARAM)) {
            planKey = this.getParameter(CHAIN_KEY_PARAM);
        }
        if (planKey != null) {
            Plan plan = this.planManager.getPlanByKey(planKey, Plan.class);
            if (plan == null) {
                return null;
            }
            return (Chain)Narrow.to((Object)plan, Chain.class);
        }
        log.info((Object)("Chain could not be found, key not specified " + (ServletActionContext.getRequest() != null ? ServletActionContext.getRequest().getRequestURI() : "")));
        return null;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

