/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.interceptors;

import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.IncorrectResultSummaryTypeException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.ww2.aware.BuildResultsSummaryAware;
import com.atlassian.bamboo.ww2.interceptors.AbstractBambooInterceptor;
import com.opensymphony.xwork2.ActionInvocation;
import org.apache.log4j.Logger;

public class BuildResultsSummaryAwareInteceptor
extends AbstractBambooInterceptor {
    private static final Logger log = Logger.getLogger(BuildResultsSummaryAwareInteceptor.class);
    private static final String BUILD_NUMBER = "buildNumber";
    private ResultsSummaryManager resultsSummaryManager;

    @Override
    public String doIntercept(ActionInvocation actionInvocation) throws Exception {
        block9: {
            Object action = actionInvocation.getAction();
            if (action instanceof BuildResultsSummaryAware) {
                try {
                    BuildResultsSummaryAware brsAware = (BuildResultsSummaryAware)action;
                    if (this.hasParameter(BUILD_NUMBER) && (this.hasParameter("buildKey") || this.hasParameter("planKey"))) {
                        String buildNumber = this.getParameter(BUILD_NUMBER);
                        String buildKey = this.getBuildKeyParameter();
                        try {
                            PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)buildKey, (int)Integer.parseInt(buildNumber));
                            BuildResultsSummary buildResultsSummary = (BuildResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, BuildResultsSummary.class);
                            if (buildResultsSummary != null) {
                                brsAware.setBuildResultsSummary(buildResultsSummary);
                                break block9;
                            }
                            log.warn((Object)("Action " + action + "' is buildResultsSummaryAware but no buildResultSummary can be found"));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        break block9;
                    }
                    BuildResultsSummary buildResultsSummary = (BuildResultsSummary)this.resultsSummaryManager.getLastResultsSummary(this.getBuildKeyParameter(), BuildResultsSummary.class);
                    if (buildResultsSummary != null) {
                        brsAware.setBuildResultsSummary(buildResultsSummary);
                    } else {
                        log.info((Object)("Action " + action + "' is buildResultsSummaryAware but no build number can be found"));
                    }
                }
                catch (IncorrectResultSummaryTypeException e) {
                    log.info((Object)("Action " + action + " is buildResultsSummaryAware but was called for chain result summary"));
                    return "fourOhFour";
                }
            }
        }
        return actionInvocation.invoke();
    }

    private String getBuildKeyParameter() {
        return this.hasParameter("buildKey") ? this.getParameter("buildKey") : this.getParameter("planKey");
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

